/*
 * Decompiled with CFR 0.152.
 */
package xiaofei.library.comparatorgenerator.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.TreeMap;
import xiaofei.library.comparatorgenerator.Criterion;
import xiaofei.library.comparatorgenerator.Order;
import xiaofei.library.comparatorgenerator.internal.FieldMember;
import xiaofei.library.comparatorgenerator.internal.MethodMember;
import xiaofei.library.comparatorgenerator.internal.SortingCriterion;
import xiaofei.library.comparatorgenerator.internal.TypeUtils;

public class AnnotationUtils {
    private AnnotationUtils() {
    }

    public static TreeMap<Integer, SortingCriterion> getCriteriaIn(Class<?> clazz) {
        TreeMap<Integer, SortingCriterion> map = new TreeMap<Integer, SortingCriterion>();
        List<Field> fields = TypeUtils.getFields(clazz);
        for (Field field : fields) {
            Criterion criterion = field.getAnnotation(Criterion.class);
            if (criterion == null) continue;
            TypeUtils.checkField(field);
            int priority = criterion.priority();
            Order order = criterion.order();
            SortingCriterion prev = map.put(priority, new SortingCriterion(new FieldMember(field), order));
            if (prev == null) continue;
            throw new RuntimeException("The priority value " + priority + " has already been set to the member " + prev.getMember().getName() + ". Please specify another priority value.");
        }
        List<Method> methods = TypeUtils.getNoArgMethods(clazz);
        for (Method method : methods) {
            Criterion criterion = method.getAnnotation(Criterion.class);
            if (criterion == null) continue;
            TypeUtils.checkMethod(method);
            int priority = criterion.priority();
            Order order = criterion.order();
            SortingCriterion prev = map.put(priority, new SortingCriterion(new MethodMember(method), order));
            if (prev == null) continue;
            throw new RuntimeException("The priority value " + priority + " has already been set to the member " + prev.getMember().getName() + ". Please specify another priority value.");
        }
        return map;
    }
}

