/*
 * Decompiled with CFR 0.152.
 */
package xiaofei.library.comparatorgenerator;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import xiaofei.library.comparatorgenerator.AnnotationUtils;
import xiaofei.library.comparatorgenerator.Order;
import xiaofei.library.comparatorgenerator.TypeUtils;

public class ComparatorGenerator<T> {
    private Class<T> clazz;
    private TreeMap<Integer, SortingCriterion> criteria;

    public ComparatorGenerator(Class<T> clazz) {
        this.clazz = clazz;
        this.criteria = new TreeMap(new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return -o1.compareTo(o2);
            }
        });
        TreeMap<Integer, SortingCriterion> map = AnnotationUtils.getCriterionAnnotation(clazz);
        for (Map.Entry<Integer, SortingCriterion> entry : map.entrySet()) {
            SortingCriterion prev = this.criteria.put(entry.getKey(), entry.getValue());
            if (prev == null) continue;
            throw new RuntimeException("The priority value " + entry.getKey() + " has already been set to field " + prev.getField().getName() + ". Please specify another priority value.");
        }
    }

    public ComparatorGenerator<T> addCriterion(int priority, String fieldName) {
        return this.addCriterion(priority, fieldName, Order.ASCENDING);
    }

    public ComparatorGenerator<T> addCriterion(int priority, String fieldName, Order order) {
        Field field = TypeUtils.getField(this.clazz, fieldName);
        if (field == null) {
            throw new IllegalArgumentException("The field " + fieldName + " does not exist.");
        }
        TypeUtils.checkField(field);
        SortingCriterion prev = this.criteria.put(priority, new SortingCriterion(field, order));
        if (prev != null) {
            throw new IllegalArgumentException("The priority value " + priority + " has already been set to field " + prev.getField().getName() + ". Please specify another priority value.");
        }
        return this;
    }

    public Comparator<T> generate() {
        ArrayList<SortingCriterion> criteria = new ArrayList<SortingCriterion>();
        criteria.addAll(this.criteria.values());
        if (criteria.isEmpty()) {
            throw new RuntimeException("There is no sorting criterion specified. Please specify at least one criterion by adding @Criterion on the corresponing field or using ComparatorGenerator.addCriterion(int, String, Order).");
        }
        this.clazz = null;
        this.criteria = null;
        return new GeneratedComparator(criteria);
    }

    static class SortingCriterion {
        private Field field;
        private Order order;

        SortingCriterion(Field field, Order order) {
            this.field = field;
            this.order = order;
        }

        Field getField() {
            return this.field;
        }

        Order getOrder() {
            return this.order;
        }
    }

    private static class GeneratedComparator<T>
    implements Comparator<T> {
        private List<SortingCriterion> criteria;

        public GeneratedComparator(List<SortingCriterion> criteria) {
            this.criteria = criteria;
        }

        @Override
        public int compare(T o1, T o2) {
            if (o1 == null || o2 == null) {
                throw new NullPointerException("Argument is null.");
            }
            for (SortingCriterion criterion : this.criteria) {
                Object v2;
                Object v1;
                Field field = criterion.getField();
                try {
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    v1 = field.get(o1);
                    v2 = field.get(o2);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e.getMessage());
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e.getMessage());
                }
                if (v1 == null) {
                    throw new NullPointerException("Field " + field.getName() + " of " + o1 + " is null.");
                }
                if (v2 == null) {
                    throw new NullPointerException("Field " + field.getName() + " of " + o2 + " is null.");
                }
                Order order = criterion.getOrder();
                if (v1 instanceof Comparable && v2 instanceof Comparable) {
                    int result = ((Comparable)Comparable.class.cast(v1)).compareTo(Comparable.class.cast(v2));
                    if (result == 0) continue;
                    return order == Order.ASCENDING ? result : -result;
                }
                Class<?> type = field.getType();
                int result = 0;
                if (type == Boolean.TYPE) {
                    result = Boolean.valueOf((Boolean)v1).compareTo((boolean)((Boolean)v2));
                } else if (type == Byte.TYPE) {
                    result = Byte.valueOf((Byte)v1).compareTo((byte)((Byte)v2));
                } else if (type == Character.TYPE) {
                    result = Character.valueOf(((Character)v1).charValue()).compareTo(Character.valueOf(((Character)v2).charValue()));
                } else if (type == Short.TYPE) {
                    result = Short.valueOf((Short)v1).compareTo((short)((Short)v2));
                } else if (type == Integer.TYPE) {
                    result = Integer.valueOf((Integer)v1).compareTo((int)((Integer)v2));
                } else if (type == Long.TYPE) {
                    result = Long.valueOf((Long)v1).compareTo((long)((Long)v2));
                } else if (type == Float.TYPE) {
                    result = Float.valueOf(((Float)v1).floatValue()).compareTo(Float.valueOf(((Float)v2).floatValue()));
                } else if (type == Double.TYPE) {
                    result = Double.valueOf((Double)v1).compareTo((double)((Double)v2));
                } else {
                    throw new RuntimeException("Congratulations! You have found a bug which I do not know. Please tell me so that I can add it here.");
                }
                if (result == 0) continue;
                return order == Order.ASCENDING ? result : -result;
            }
            return 0;
        }
    }
}

