/*
 * Decompiled with CFR 0.152.
 */
package xiaofei.library.comparatorgenerator;

import java.lang.reflect.Field;
import java.util.List;
import java.util.TreeMap;
import xiaofei.library.comparatorgenerator.ComparatorGenerator;
import xiaofei.library.comparatorgenerator.Criterion;
import xiaofei.library.comparatorgenerator.Order;
import xiaofei.library.comparatorgenerator.TypeUtils;

public class AnnotationUtils {
    private AnnotationUtils() {
    }

    public static TreeMap<Integer, ComparatorGenerator.SortingCriterion> getCriterionAnnotation(Class<?> clazz) {
        TreeMap<Integer, ComparatorGenerator.SortingCriterion> map = new TreeMap<Integer, ComparatorGenerator.SortingCriterion>();
        List<Field> fields = TypeUtils.getFields(clazz);
        for (Field field : fields) {
            Criterion criterion = field.getAnnotation(Criterion.class);
            if (criterion == null) continue;
            TypeUtils.checkField(field);
            int priority = criterion.priority();
            Order order = criterion.order();
            ComparatorGenerator.SortingCriterion prev = map.put(priority, new ComparatorGenerator.SortingCriterion(field, order));
            if (prev == null) continue;
            throw new RuntimeException("The priority value " + priority + " has already been set to field " + prev.getField().getName() + " of class " + prev.getField().getDeclaringClass().getName() + ". Please specify another priority value.");
        }
        return map;
    }
}

