/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.modules.hibernate;

import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import org.apache.commons.logging.Log;
import xdoclet.DocletContext;
import xdoclet.DocletSupport;
import xdoclet.DocletTask;
import xdoclet.XDocletException;
import xdoclet.XDocletTagSupport;
import xdoclet.modules.hibernate.FactoryClassSubTask;
import xdoclet.modules.hibernate.HibernateSubTask;
import xdoclet.modules.hibernate.JBossServiceSubTask;
import xdoclet.modules.hibernate.XDocletModulesHibernateMessages;
import xdoclet.tagshandler.ClassTagsHandler;
import xdoclet.tagshandler.TypeTagsHandler;
import xdoclet.template.TemplateTagHandler;
import xdoclet.util.LogUtil;
import xdoclet.util.Translator;
import xjavadoc.XClass;
import xjavadoc.XMethod;

public class HibernateTagsHandler
extends XDocletTagSupport {
    private String currentTag;
    private String currentMappingElement;
    static /* synthetic */ Class class$xdoclet$modules$hibernate$JBossServiceSubTask;
    static /* synthetic */ Class class$xdoclet$modules$hibernate$FactoryClassSubTask;
    static /* synthetic */ Class class$xdoclet$modules$hibernate$HibernateTagsHandler;
    static /* synthetic */ Class class$xdoclet$modules$hibernate$XDocletModulesHibernateMessages;
    static /* synthetic */ Class class$xdoclet$modules$hibernate$HibernateSubTask;

    public String getFileName() throws XDocletException {
        return XDocletTagSupport.getCurrentClass().getQualifiedName().replace('.', '/');
    }

    public JBossServiceSubTask getJBossServiceSubTask() {
        return (JBossServiceSubTask)DocletContext.getInstance().getSubTaskBy(DocletTask.getSubTaskName((Class)(class$xdoclet$modules$hibernate$JBossServiceSubTask == null ? (class$xdoclet$modules$hibernate$JBossServiceSubTask = HibernateTagsHandler.class$("xdoclet.modules.hibernate.JBossServiceSubTask")) : class$xdoclet$modules$hibernate$JBossServiceSubTask)));
    }

    public FactoryClassSubTask getFactoryClassSubTask() {
        return (FactoryClassSubTask)DocletContext.getInstance().getSubTaskBy(DocletTask.getSubTaskName((Class)(class$xdoclet$modules$hibernate$FactoryClassSubTask == null ? (class$xdoclet$modules$hibernate$FactoryClassSubTask = HibernateTagsHandler.class$("xdoclet.modules.hibernate.FactoryClassSubTask")) : class$xdoclet$modules$hibernate$FactoryClassSubTask)));
    }

    public XMethod getIdMethod() throws XDocletException {
        XClass clazz = XDocletTagSupport.getCurrentClass();
        Iterator methodIterator = clazz.getMethods(true).iterator();
        while (methodIterator.hasNext()) {
            XMethod method = (XMethod)methodIterator.next();
            if (!method.getDoc().hasTag("hibernate.id")) continue;
            return method;
        }
        return null;
    }

    public String getCurrentTag(Properties attributes) {
        return this.currentTag;
    }

    public String getCurrentMappingElement(Properties attributes) {
        return this.currentMappingElement;
    }

    public void setCurrentTag(String template, Properties attributes) throws XDocletException {
        this.currentTag = attributes.getProperty("name");
        this.currentMappingElement = attributes.getProperty("mappingElement");
        this.generate(template);
        this.currentTag = null;
        this.currentMappingElement = null;
    }

    public String roleAttribute(Properties attributes) {
        return "1.1".equals(this.getHibernateSubTask().getVersion()) ? "role" : "name";
    }

    public String serviceClassName(Properties attributes) {
        if ("1.1".equals(this.getHibernateSubTask().getVersion())) {
            return "cirrus.hibernate.jmx.HibernateService";
        }
        return "net.sf.hibernate.jmx.HibernateService";
    }

    public void ifHasCompositeId(String template, Properties attributes) throws XDocletException {
        this.hasCompositeId_Impl(template, true);
    }

    public void ifHasPrimitiveId(String template, Properties attributes) throws XDocletException {
        this.hasCompositeId_Impl(template, false);
    }

    public String serviceName() throws XDocletException {
        return this.getJBossServiceSubTask().getServiceName();
    }

    public String jndiName() throws XDocletException {
        JBossServiceSubTask jBossServiceSubTask = this.getJBossServiceSubTask();
        String result = null;
        if (jBossServiceSubTask != null) {
            result = jBossServiceSubTask.getJndiName();
        }
        return result;
    }

    public void ifHasJndiName(String template, Properties attributes) throws XDocletException {
        if (this.jndiName() != null) {
            this.generate(template);
        }
    }

    public void ifGeneratePropertyCache(String template, Properties attributes) throws XDocletException {
        if (this.factoryDialect() != null && this.factoryDriver() != null && this.factoryDataSource() != null && this.factoryUsername() != null && this.factoryPassword() != null) {
            this.generate(template);
        }
    }

    public void ifNotHasJndiName(String template, Properties attributes) throws XDocletException {
        if (this.jndiName() == null) {
            this.generate(template);
        }
    }

    public String dialect() throws XDocletException {
        return this.getJBossServiceSubTask().getDialect();
    }

    public String dataSource() throws XDocletException {
        return this.getJBossServiceSubTask().getDataSource();
    }

    public String factoryDialect() throws XDocletException {
        if (this.getFactoryClassSubTask().getDialect() != null) {
            return this.getFactoryClassSubTask().getDialect();
        }
        return this.getJBossServiceSubTask().getDialect();
    }

    public String factoryDataSource() throws XDocletException {
        if (this.getFactoryClassSubTask().getDataSource() != null) {
            return this.getFactoryClassSubTask().getDataSource();
        }
        return this.getJBossServiceSubTask().getDataSource();
    }

    public String factoryDriver() throws XDocletException {
        return this.getFactoryClassSubTask().getDriver();
    }

    public String factoryUsername() throws XDocletException {
        return this.getFactoryClassSubTask().getUsername();
    }

    public String factoryPassword() throws XDocletException {
        return this.getFactoryClassSubTask().getPassword();
    }

    public String factoryClass() throws XDocletException {
        return this.getFactoryClassSubTask().getFactoryClass();
    }

    public String mappingList() throws XDocletException {
        StringBuffer sb = new StringBuffer();
        Collection classes = ClassTagsHandler.getAllClasses();
        Iterator i = classes.iterator();
        while (i.hasNext()) {
            XClass clazz = (XClass)i.next();
            if (!clazz.getDoc().hasTag("hibernate.class", false)) continue;
            String mappingName = this.getHibernateSubTask().getMappingURL(clazz);
            sb.append(mappingName);
            sb.append(",");
        }
        if (sb.length() > 0) {
            return sb.substring(0, sb.length() - 1);
        }
        return "";
    }

    public void logMapping(Properties attributes) throws XDocletException {
        System.out.println("   " + XDocletTagSupport.getCurrentClass().getQualifiedName());
    }

    public void forAllPersistentClasses(String template, Properties attributes) throws XDocletException {
        Collection classes = ClassTagsHandler.getAllClasses();
        Iterator i = classes.iterator();
        while (i.hasNext()) {
            XClass clazz = (XClass)i.next();
            if (!clazz.getDoc().hasTag("hibernate.class", false)) continue;
            XDocletTagSupport.pushCurrentClass((XClass)clazz);
            this.generate(template);
            XDocletTagSupport.popCurrentClass();
        }
    }

    public void forAllSubclasses(String template, Properties attributes) throws XDocletException {
        Log log = LogUtil.getLog((Class)(class$xdoclet$modules$hibernate$HibernateTagsHandler == null ? (class$xdoclet$modules$hibernate$HibernateTagsHandler = HibernateTagsHandler.class$("xdoclet.modules.hibernate.HibernateTagsHandler")) : class$xdoclet$modules$hibernate$HibernateTagsHandler), (String)"forAllSubclasses");
        try {
            String typeName = XDocletTagSupport.getCurrentClass().getQualifiedName();
            if (log.isDebugEnabled()) {
                log.debug((Object)("typeName=" + typeName));
            }
            Collection classes = TemplateTagHandler.getXJavaDoc().getSourceClasses();
            Iterator i = classes.iterator();
            while (i.hasNext()) {
                XClass clazz = (XClass)i.next();
                log.debug((Object)("clazz=" + clazz));
                if (DocletSupport.isDocletGenerated((XClass)clazz)) {
                    log.debug((Object)"isDocletGenerated");
                    continue;
                }
                if (clazz.getSuperclass() != null && clazz.getSuperclass().getQualifiedName().equals(typeName)) {
                    log.debug((Object)"is a subclass");
                    XClass current = XDocletTagSupport.getCurrentClass();
                    XDocletTagSupport.pushCurrentClass((XClass)clazz);
                    this.generate(template);
                    XDocletTagSupport.popCurrentClass();
                    if (XDocletTagSupport.getCurrentClass() == current) continue;
                    XDocletTagSupport.setCurrentClass((XClass)current);
                    continue;
                }
                log.debug((Object)"is not a subclass");
            }
        }
        catch (Exception e) {
            log.error((Object)"exception occurred", (Throwable)e);
        }
    }

    void hasCompositeId_Impl(String template, boolean composite) throws XDocletException {
        String type;
        boolean isPrimitive;
        XClass typeClass;
        XClass oldClass = XDocletTagSupport.getCurrentClass();
        XMethod method = this.getIdMethod();
        if (method == null) {
            throw new XDocletException(Translator.getString((Class)(class$xdoclet$modules$hibernate$XDocletModulesHibernateMessages == null ? (class$xdoclet$modules$hibernate$XDocletModulesHibernateMessages = HibernateTagsHandler.class$("xdoclet.modules.hibernate.XDocletModulesHibernateMessages")) : class$xdoclet$modules$hibernate$XDocletModulesHibernateMessages), (String)XDocletModulesHibernateMessages.NO_ID_PROPERTY, (String[])new String[]{XDocletTagSupport.getCurrentClass().getQualifiedName()}));
        }
        boolean isUserType = false;
        String typeStr = method.getDoc().getTagAttributeValue("hibernate.id", "type");
        if (typeStr != null && (typeClass = TemplateTagHandler.getXJavaDoc().getXClass(typeStr)) != null) {
            isUserType = typeClass.isA("cirrus.hibernate.UserType") || typeClass.isA("net.sf.hibernate.UserType");
        }
        boolean bl = isPrimitive = TypeTagsHandler.isPrimitiveType((String)(type = method.getReturnType().getType().getQualifiedName())) || "java.lang.Byte".equals(type) || "java.lang.Double".equals(type) || "java.lang.Float".equals(type) || "java.lang.Integer".equals(type) || "java.lang.Long".equals(type) || "java.lang.Short".equals(type) || "java.lang.String".equals(type) || "java.math.BigDecimal".equals(type) || isUserType;
        if (isPrimitive && !composite) {
            XDocletTagSupport.setCurrentMethod((XMethod)method);
            this.generate(template);
        }
        if (composite && !isPrimitive) {
            XClass returnType = method.getReturnType().getType();
            if (returnType.isA("java.io.Serializable") && !returnType.isAbstract() && !"java.lang.Object".equals(returnType.getMethod("equals(java.lang.Object)", true).getContainingClass().getQualifiedName())) {
                XDocletTagSupport.setCurrentMethod((XMethod)method);
                this.generate(template);
            } else {
                throw new XDocletException(Translator.getString((Class)(class$xdoclet$modules$hibernate$XDocletModulesHibernateMessages == null ? (class$xdoclet$modules$hibernate$XDocletModulesHibernateMessages = HibernateTagsHandler.class$("xdoclet.modules.hibernate.XDocletModulesHibernateMessages")) : class$xdoclet$modules$hibernate$XDocletModulesHibernateMessages), (String)XDocletModulesHibernateMessages.WRONG_COMPOSITE_ID, (String[])new String[]{returnType.getQualifiedName()}));
            }
        }
        if (XDocletTagSupport.getCurrentClass() != oldClass) {
            XDocletTagSupport.setCurrentClass((XClass)oldClass);
        }
    }

    private HibernateSubTask getHibernateSubTask() {
        return (HibernateSubTask)DocletContext.getInstance().getSubTaskBy(DocletTask.getSubTaskName((Class)(class$xdoclet$modules$hibernate$HibernateSubTask == null ? (class$xdoclet$modules$hibernate$HibernateSubTask = HibernateTagsHandler.class$("xdoclet.modules.hibernate.HibernateSubTask")) : class$xdoclet$modules$hibernate$HibernateSubTask)));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

