/*
 * Decompiled with CFR 0.152.
 */
package org.xdoclet.testapp.ejb.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.Hashtable;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class TransferReceiverUtil {
    private static final String DESTINATION_JNDI_NAME = "dest/jndi/queue";
    private static final String CONNECTION_FACTORY_JNDI_NAME = "jndi/conn/factory";
    private static Queue cachedQueue = null;
    private static QueueConnectionFactory cachedConnectionFactory = null;
    private static String hexServerIP = null;
    private static final SecureRandom seeder = new SecureRandom();

    public static Queue getQueue() throws NamingException {
        Queue retVal = cachedQueue;
        if (retVal == null) {
            cachedQueue = retVal = (Queue)TransferReceiverUtil.lookup(null, DESTINATION_JNDI_NAME);
        }
        return retVal;
    }

    public static Queue getQueue(Hashtable environment) throws NamingException {
        return (Queue)TransferReceiverUtil.lookup(environment, DESTINATION_JNDI_NAME);
    }

    public static QueueConnection getQueueConnection() throws NamingException, JMSException {
        QueueConnectionFactory factory = cachedConnectionFactory;
        if (factory == null) {
            cachedConnectionFactory = factory = (QueueConnectionFactory)TransferReceiverUtil.lookup(null, CONNECTION_FACTORY_JNDI_NAME);
        }
        return factory.createQueueConnection();
    }

    public static QueueConnection getQueueConnection(Hashtable environment) throws NamingException, JMSException {
        QueueConnectionFactory factory = (QueueConnectionFactory)TransferReceiverUtil.lookup(environment, CONNECTION_FACTORY_JNDI_NAME);
        return factory.createQueueConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object lookup(Hashtable env, String jndiName) throws NamingException {
        InitialContext initialContext = new InitialContext(env);
        try {
            Object object = initialContext.lookup(jndiName);
            return object;
        }
        finally {
            initialContext.close();
        }
    }

    public static final String generateGUID(Object o) {
        if (hexServerIP == null) {
            byte[] ipBytes;
            try {
                ipBytes = InetAddress.getLocalHost().getAddress();
            }
            catch (UnknownHostException uhe) {
                ipBytes = new byte[4];
                seeder.nextBytes(ipBytes);
            }
            hexServerIP = TransferReceiverUtil.hexFormat(ipBytes, 8);
        }
        int timeLow = (int)(System.currentTimeMillis() & 0xFFFFFFFFFFFFFFFFL);
        int node = seeder.nextInt();
        StringBuffer guid = new StringBuffer(32);
        guid.append(TransferReceiverUtil.hexFormat(timeLow, 8));
        guid.append(hexServerIP);
        guid.append(TransferReceiverUtil.hexFormat(System.identityHashCode(o), 8));
        guid.append(TransferReceiverUtil.hexFormat(node, 8));
        return guid.toString();
    }

    private static String hexFormat(byte[] value, int length) {
        StringBuffer retBuf = new StringBuffer();
        for (int i = 0; i < value.length; ++i) {
            int x = value[i] & 0xFF;
            retBuf.append((x < 16 ? "0" : "") + Integer.toString(x, 16));
        }
        while (retBuf.length() < length) {
            retBuf.insert(0, '0');
        }
        return retBuf.toString();
    }

    private static String hexFormat(int value, int length) {
        StringBuffer retBuf = new StringBuffer(Integer.toHexString(value));
        while (retBuf.length() < length) {
            retBuf.insert(0, '0');
        }
        return retBuf.toString();
    }
}

