/*
 * Decompiled with CFR 0.152.
 */
package org.xdoclet.testapp.ejb.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.xdoclet.testapp.ejb.interfaces.AccountLocalHome;
import org.xdoclet.testapp.ejb.interfaces.AccountRemoteHome;

public class AccountUtil {
    private static AccountRemoteHome cachedRemoteHome = null;
    private static AccountLocalHome cachedHome = null;
    private static String hexServerIP = null;
    private static final SecureRandom seeder = new SecureRandom();
    static /* synthetic */ Class class$org$xdoclet$testapp$ejb$interfaces$AccountRemoteHome;
    static /* synthetic */ Class class$org$xdoclet$testapp$ejb$interfaces$AccountLocalHome;
    static /* synthetic */ Class class$java$rmi$Remote;

    public AccountRemoteHome getHome() throws NamingException {
        AccountRemoteHome retVal = cachedRemoteHome;
        if (retVal == null) {
            cachedRemoteHome = retVal = (AccountRemoteHome)AccountUtil.lookupHome(null, "AccountRemote", class$org$xdoclet$testapp$ejb$interfaces$AccountRemoteHome == null ? (class$org$xdoclet$testapp$ejb$interfaces$AccountRemoteHome = AccountUtil.class$("org.xdoclet.testapp.ejb.interfaces.AccountRemoteHome")) : class$org$xdoclet$testapp$ejb$interfaces$AccountRemoteHome);
        }
        return retVal;
    }

    public AccountRemoteHome getHome(Hashtable env) throws NamingException {
        return (AccountRemoteHome)AccountUtil.lookupHome(env, "AccountRemote", class$org$xdoclet$testapp$ejb$interfaces$AccountRemoteHome == null ? (class$org$xdoclet$testapp$ejb$interfaces$AccountRemoteHome = AccountUtil.class$("org.xdoclet.testapp.ejb.interfaces.AccountRemoteHome")) : class$org$xdoclet$testapp$ejb$interfaces$AccountRemoteHome);
    }

    public AccountLocalHome getLocalHome() throws NamingException {
        AccountLocalHome retVal = cachedHome;
        if (retVal == null) {
            cachedHome = retVal = (AccountLocalHome)AccountUtil.lookupHome(null, "AccountLocal", class$org$xdoclet$testapp$ejb$interfaces$AccountLocalHome == null ? (class$org$xdoclet$testapp$ejb$interfaces$AccountLocalHome = AccountUtil.class$("org.xdoclet.testapp.ejb.interfaces.AccountLocalHome")) : class$org$xdoclet$testapp$ejb$interfaces$AccountLocalHome);
        }
        return retVal;
    }

    public AccountLocalHome getLocalHome(Hashtable env) throws NamingException {
        return (AccountLocalHome)AccountUtil.lookupHome(env, "AccountLocal", class$org$xdoclet$testapp$ejb$interfaces$AccountLocalHome == null ? (class$org$xdoclet$testapp$ejb$interfaces$AccountLocalHome = AccountUtil.class$("org.xdoclet.testapp.ejb.interfaces.AccountLocalHome")) : class$org$xdoclet$testapp$ejb$interfaces$AccountLocalHome);
    }

    private static Object lookupHome(Hashtable env, String jndiName, Class narrowTo) throws NamingException {
        Object retVal = AccountUtil.lookup(env, jndiName);
        if ((class$java$rmi$Remote == null ? (class$java$rmi$Remote = AccountUtil.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(narrowTo)) {
            retVal = PortableRemoteObject.narrow((Object)retVal, (Class)narrowTo);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object lookup(Hashtable env, String jndiName) throws NamingException {
        InitialContext initialContext = new InitialContext(env);
        try {
            Object object = initialContext.lookup(jndiName);
            return object;
        }
        finally {
            initialContext.close();
        }
    }

    public static final String generateGUID(Object o) {
        if (hexServerIP == null) {
            byte[] ipBytes;
            try {
                ipBytes = InetAddress.getLocalHost().getAddress();
            }
            catch (UnknownHostException uhe) {
                ipBytes = new byte[4];
                seeder.nextBytes(ipBytes);
            }
            hexServerIP = AccountUtil.hexFormat(ipBytes, 8);
        }
        int timeLow = (int)(System.currentTimeMillis() & 0xFFFFFFFFFFFFFFFFL);
        int node = seeder.nextInt();
        StringBuffer guid = new StringBuffer(32);
        guid.append(AccountUtil.hexFormat(timeLow, 8));
        guid.append(hexServerIP);
        guid.append(AccountUtil.hexFormat(System.identityHashCode(o), 8));
        guid.append(AccountUtil.hexFormat(node, 8));
        return guid.toString();
    }

    private static String hexFormat(byte[] value, int length) {
        StringBuffer retBuf = new StringBuffer();
        for (int i = 0; i < value.length; ++i) {
            int x = value[i] & 0xFF;
            retBuf.append((x < 16 ? "0" : "") + Integer.toString(x, 16));
        }
        while (retBuf.length() < length) {
            retBuf.insert(0, '0');
        }
        return retBuf.toString();
    }

    private static String hexFormat(int value, int length) {
        StringBuffer retBuf = new StringBuffer(Integer.toHexString(value));
        while (retBuf.length() < length) {
            retBuf.insert(0, '0');
        }
        return retBuf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

