/*
 * Decompiled with CFR 0.152.
 */
package org.xdoclet.plugin.struts;

import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.generama.JellyTemplateEngine;
import org.generama.MetadataProvider;
import org.generama.OutputValidator;
import org.generama.QDoxCapableMetadataProvider;
import org.generama.TemplateEngine;
import org.generama.WriterMapper;
import org.generama.defaults.QDoxPlugin;
import org.generama.defaults.XMLOutputValidator;
import org.xdoclet.plugin.struts.qtags.StrutsTilesPutTagImpl;
import org.xdoclet.plugin.struts.qtags.StrutsTilesTagImpl;
import org.xdoclet.plugin.struts.qtags.TagLibrary;

public class StrutsTilesPlugin
extends QDoxPlugin {
    private String fileName = "tiles-defs.xml";
    private File mergedir;
    private Map defs;

    public StrutsTilesPlugin(JellyTemplateEngine templateEngine, QDoxCapableMetadataProvider metadataProvider, WriterMapper writerMapper) {
        super((TemplateEngine)templateEngine, metadataProvider, writerMapper);
        this.setMultioutput(false);
        Map<String, URL> dtds = Collections.singletonMap("http://jakarta.apache.org/struts/dtds/tiles-config.dtd", ((Object)((Object)this)).getClass().getResource("tiles-config_1_1.dtd"));
        this.setOutputValidator((OutputValidator)new XMLOutputValidator(dtds));
        new TagLibrary((MetadataProvider)metadataProvider);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public File getMergedir() {
        return this.mergedir;
    }

    public void setMergedir(File mergefile) {
        this.mergedir = mergefile;
    }

    public File getMergeFile(String fileName) {
        if (fileName != null && this.getMergedir() != null && this.getMergedir().isDirectory()) {
            File[] files = this.getMergedir().listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!fileName.trim().equals(files[i].getName())) continue;
                return files[i];
            }
        }
        return null;
    }

    public void start() {
        this.setFilereplace(this.getFileName());
        super.start();
        System.out.println(" * Generating file " + this.getFileName());
    }

    public Map getAllDefs() {
        if (this.defs == null) {
            this.defs = new TreeMap();
            Collection metadata = this.metadataProvider.getMetadata();
            Iterator it = metadata.iterator();
            while (it.hasNext()) {
                JavaClass clazz = (JavaClass)it.next();
                System.out.println(" * Processing file " + clazz.getFullyQualifiedName());
                DocletTag[] tags1 = clazz.getTagsByName("struts.tiles");
                Definition def = null;
                for (int i = 0; i < tags1.length; ++i) {
                    StrutsTilesTagImpl tag = (StrutsTilesTagImpl)tags1[i];
                    def = new Definition(tag);
                    this.defs.put(tag.getName_(), def);
                }
                if (def == null) continue;
                DocletTag[] tags2 = clazz.getTagsByName("struts.tiles-put");
                for (int i = 0; i < tags2.length; ++i) {
                    StrutsTilesPutTagImpl tag = (StrutsTilesPutTagImpl)tags2[i];
                    String parent = tag.getParent();
                    if (parent == null) {
                        parent = def.getName();
                    }
                    if ((def = (Definition)this.defs.get(parent)) == null) continue;
                    def.props.put(tag.getName_(), tag.getValue_());
                }
            }
        }
        return this.defs;
    }

    public class Definition {
        private String name;
        private String path;
        private String eztends;
        private Map props = new TreeMap();

        public Definition(StrutsTilesTagImpl tag) {
            this.name = tag.getName_();
            this.eztends = tag.getExtends();
            this.path = tag.getPath();
        }

        public String getExtends() {
            return this.eztends;
        }

        public void setExtends(String eztends) {
            this.eztends = eztends;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public Map getProps() {
            return this.props;
        }

        public void setProps(Map props) {
            this.props = props;
        }
    }
}

