/*
 * Decompiled with CFR 0.152.
 */
package org.xdoclet.plugin.plugin;

import com.thoughtworks.qdox.model.BeanProperty;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.Type;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.generama.MetadataProvider;
import org.generama.QDoxCapableMetadataProvider;
import org.generama.TemplateEngine;
import org.generama.VelocityTemplateEngine;
import org.generama.WriterMapper;
import org.generama.defaults.QDoxPlugin;
import org.xdoclet.plugin.plugin.qtags.TagLibrary;

public class PluginPlugin
extends QDoxPlugin {
    private String basedir;
    private String generamaSourcesDir;
    static /* synthetic */ Class class$org$generama$Plugin;

    public PluginPlugin(VelocityTemplateEngine velocityTemplateEngine, QDoxCapableMetadataProvider metadataProvider, WriterMapper writerMapper) {
        super((TemplateEngine)velocityTemplateEngine, metadataProvider, writerMapper);
        this.setPackageregex(".");
        this.setMultioutput(true);
        new TagLibrary((MetadataProvider)metadataProvider);
    }

    public String getAllowedValues(JavaMethod method) {
        DocletTag tag = method.getTagByName("generama.property", true);
        if (tag == null) {
            return "";
        }
        String allowed = tag.getNamedParameter("allowed-values");
        if (allowed != null) {
            return allowed;
        }
        Type propertyType = method.getPropertyType();
        if (this.isBoolean(propertyType)) {
            return "true, false";
        }
        return "";
    }

    public void setBasedir(String basedir) {
        try {
            this.basedir = new File(basedir).getCanonicalPath();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getBasedir() {
        return this.basedir;
    }

    public Collection getBeanProperties(JavaClass clazz) {
        ArrayList<BeanProperty> result = new ArrayList<BeanProperty>();
        BeanProperty[] props = clazz.getBeanProperties(true);
        int i = 0;
        while (i < props.length) {
            BeanProperty prop = props[i];
            if (prop.getMutator() != null && prop.getMutator().getTagByName("generama.property") != null) {
                result.add(prop);
            }
            ++i;
        }
        return result;
    }

    public String getDefaultValue(JavaMethod method) {
        DocletTag tag = method.getTagByName("generama.property", true);
        if (tag == null) {
            return "";
        }
        String defaultValue = tag.getNamedParameter("default");
        if (defaultValue != null) {
            return defaultValue;
        }
        if (this.isBoolean(method.getPropertyType())) {
            return "false";
        }
        return "";
    }

    public String getDescription(JavaMethod method) {
        String comment = method.getComment();
        if (comment != null) {
            return comment;
        }
        return "";
    }

    public String getDestinationFilename(Object metadata) {
        String location = ((JavaClass)metadata).getParentSource().getFile().getAbsolutePath();
        String basename = this.getTopLocation(location);
        String originalFilename = this.getMetadataProvider().getOriginalFileName(metadata);
        String name = originalFilename.substring(0, originalFilename.lastIndexOf(46));
        return basename + "-" + name + ".confluence";
    }

    public void setGeneramasourcesdir(String generamaSourcesDir) {
        try {
            this.generamaSourcesDir = new File(generamaSourcesDir).getCanonicalPath();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot resolve Generama sources dir");
        }
    }

    public String isRequired(JavaMethod method) {
        DocletTag tag = method.getTagByName("generama.property", true);
        if (tag == null) {
            return "false";
        }
        String required = tag.getNamedParameter("required");
        if (required != null) {
            return required;
        }
        return "false";
    }

    public boolean shouldGenerate(Object metadata) {
        JavaClass javaClass = (JavaClass)metadata;
        if (this.generamaSourcesDir != null && javaClass.getParentSource().getFile().getAbsolutePath().startsWith(this.generamaSourcesDir)) {
            return false;
        }
        return javaClass.isA((class$org$generama$Plugin == null ? (class$org$generama$Plugin = PluginPlugin.class$("org.generama.Plugin")) : class$org$generama$Plugin).getName()) && !javaClass.isAbstract() && javaClass.getTagByName("generama.ignore") == null;
    }

    String getTopLocation(String location) {
        if (this.basedir == null) {
            throw new IllegalStateException("basedir must be set");
        }
        if (!location.startsWith(this.basedir)) {
            throw new IllegalArgumentException("Basedir must be on top of all scanner dirs(basedir=" + this.basedir + ", location=" + location + ").");
        }
        int startId = this.basedir.endsWith(File.separator) ? this.basedir.length() + 2 : this.basedir.length() + 1;
        int endIdx = location.indexOf(File.separatorChar, startId);
        return location.substring(startId, endIdx);
    }

    private boolean isBoolean(Type propertyType) {
        String type = propertyType.getValue();
        return type.equals("boolean") || type.equals("java.lang.Boolean");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

