/*
 * Decompiled with CFR 0.152.
 */
package org.xdoclet.plugin.hibernate.qtags;

import com.thoughtworks.qdox.model.AbstractJavaEntity;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.xdoclet.XDocletTag;
import org.xdoclet.plugin.hibernate.qtags.HibernateClassTag;

public class HibernateClassTagImpl
extends XDocletTag
implements HibernateClassTag {
    public static final String NAME = "hibernate.class";
    private static final List ALLOWED_PARAMETERS = Arrays.asList("mutable", "optimistic-lock", "persister", "polymorphism", "select-before-update", "where", "lazy", "dynamic-insert", "discriminator-value", "batch-size", "dynamic-update", "schema", "table", "name", "proxy", "");
    private static final List ALLOWED_VALUES = Arrays.asList("");

    public HibernateClassTagImpl(String name, String value, AbstractJavaEntity entity, int lineNumber) {
        super(name, value, entity, lineNumber);
    }

    public Boolean isMutable() {
        boolean required = false;
        String result = this.getNamedParameter("mutable");
        if (required && result == null) {
            this.bomb("mutable=\"???\" must be specified.");
        }
        if (result != null) {
            return Boolean.valueOf(result);
        }
        return null;
    }

    public String getOptimisticLock() {
        boolean required = false;
        String result = this.getNamedParameter("optimistic-lock");
        if (required && result == null) {
            this.bomb("optimistic-lock=\"???\" must be specified.");
        }
        if (!(result == null || result.equals("none") || result.equals("dirty") || result.equals("version") || result.equals("all"))) {
            this.bomb("optimistic-lock=\"" + result + "\" is an invalid parameter value.");
        }
        return result;
    }

    public String getPersister() {
        boolean required = false;
        String result = this.getNamedParameter("persister");
        if (required && result == null) {
            this.bomb("persister=\"???\" must be specified.");
        }
        return result;
    }

    public String getPolymorphism() {
        boolean required = false;
        String result = this.getNamedParameter("polymorphism");
        if (required && result == null) {
            this.bomb("polymorphism=\"???\" must be specified.");
        }
        if (result != null && !result.equals("explicit") && !result.equals("implicit")) {
            this.bomb("polymorphism=\"" + result + "\" is an invalid parameter value.");
        }
        return result;
    }

    public Boolean getSelectBeforeUpdate() {
        boolean required = false;
        String result = this.getNamedParameter("select-before-update");
        if (required && result == null) {
            this.bomb("select-before-update=\"???\" must be specified.");
        }
        if (result != null) {
            return Boolean.valueOf(result);
        }
        return null;
    }

    public String getWhere() {
        boolean required = false;
        String result = this.getNamedParameter("where");
        if (required && result == null) {
            this.bomb("where=\"???\" must be specified.");
        }
        return result;
    }

    public Boolean getLazy() {
        boolean required = false;
        String result = this.getNamedParameter("lazy");
        if (required && result == null) {
            this.bomb("lazy=\"???\" must be specified.");
        }
        if (result != null) {
            return Boolean.valueOf(result);
        }
        return null;
    }

    public Boolean getDynamicInsert() {
        boolean required = false;
        String result = this.getNamedParameter("dynamic-insert");
        if (required && result == null) {
            this.bomb("dynamic-insert=\"???\" must be specified.");
        }
        if (result != null) {
            return Boolean.valueOf(result);
        }
        return null;
    }

    public String getDiscriminatorValue() {
        boolean required = false;
        String result = this.getNamedParameter("discriminator-value");
        if (required && result == null) {
            this.bomb("discriminator-value=\"???\" must be specified.");
        }
        return result;
    }

    public String getBatchSize() {
        boolean required = false;
        String result = this.getNamedParameter("batch-size");
        if (required && result == null) {
            this.bomb("batch-size=\"???\" must be specified.");
        }
        return result;
    }

    public Boolean getDynamicUpdate() {
        boolean required = false;
        String result = this.getNamedParameter("dynamic-update");
        if (required && result == null) {
            this.bomb("dynamic-update=\"???\" must be specified.");
        }
        if (result != null) {
            return Boolean.valueOf(result);
        }
        return null;
    }

    public String getSchema() {
        boolean required = false;
        String result = this.getNamedParameter("schema");
        if (required && result == null) {
            this.bomb("schema=\"???\" must be specified.");
        }
        return result;
    }

    public String getTable() {
        boolean required = false;
        String result = this.getNamedParameter("table");
        if (required && result == null) {
            this.bomb("table=\"???\" must be specified.");
        }
        return result;
    }

    public String getName_() {
        boolean required = false;
        String result = this.getNamedParameter("name");
        if (required && result == null) {
            this.bomb("name=\"???\" must be specified.");
        }
        return result;
    }

    public String getProxy() {
        boolean required = false;
        String result = this.getNamedParameter("proxy");
        if (required && result == null) {
            this.bomb("proxy=\"???\" must be specified.");
        }
        return result;
    }

    protected void validateLocation() {
        if (this.isOnField) {
            this.bomb("is not allowed on fields");
        }
        if (this.isOnConstructor) {
            this.bomb("is not allowed on constructors");
        }
        if (this.isOnMethod) {
            this.bomb("is not allowed on methods");
        }
        if (this.getContext().getTagsByName(NAME).length > 1) {
            this.bomb("is allowed only once");
        }
        if (ALLOWED_VALUES.size() > 1 && !ALLOWED_VALUES.contains(this.getValue())) {
            this.bomb("\"" + this.getValue() + "\" is not a valid value. Allowed values are ");
        }
        Set parameterNames = this.getNamedParameterMap().keySet();
        Iterator iterator = parameterNames.iterator();
        while (iterator.hasNext()) {
            String parameterName = (String)iterator.next();
            if (ALLOWED_PARAMETERS.contains(parameterName)) continue;
            this.bomb(parameterName + " is an invalid parameter name.");
        }
        this.isMutable();
        this.getOptimisticLock();
        this.getPersister();
        this.getPolymorphism();
        this.getSelectBeforeUpdate();
    }
}

