/*
 * Decompiled with CFR 0.152.
 */
package org.xdoclet.plugin.hibernate.qtags;

import com.thoughtworks.qdox.model.AbstractJavaEntity;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.xdoclet.XDocletTag;
import org.xdoclet.plugin.hibernate.qtags.HibernatePropertyTag;

public class HibernatePropertyTagImpl
extends XDocletTag
implements HibernatePropertyTag {
    public static final String NAME = "hibernate.property";
    private static final List ALLOWED_PARAMETERS = Arrays.asList("index", "type", "insert", "unique", "not-null", "length", "update", "column", "formula", "");
    private static final List ALLOWED_VALUES = Arrays.asList("");

    public HibernatePropertyTagImpl(String name, String value, AbstractJavaEntity entity, int lineNumber) {
        super(name, value, entity, lineNumber);
    }

    public String getIndex() {
        boolean required = false;
        String result = this.getNamedParameter("index");
        if (required && result == null) {
            this.bomb("index=\"???\" must be specified.");
        }
        return result;
    }

    public String getType() {
        boolean required = false;
        String result = this.getNamedParameter("type");
        if (required && result == null) {
            this.bomb("type=\"???\" must be specified.");
        }
        return result;
    }

    public Boolean getInsert() {
        boolean required = false;
        String result = this.getNamedParameter("insert");
        if (required && result == null) {
            this.bomb("insert=\"???\" must be specified.");
        }
        if (result != null) {
            return Boolean.valueOf(result);
        }
        return null;
    }

    public Boolean getUnique() {
        boolean required = false;
        String result = this.getNamedParameter("unique");
        if (required && result == null) {
            this.bomb("unique=\"???\" must be specified.");
        }
        if (result != null) {
            return Boolean.valueOf(result);
        }
        return null;
    }

    public Boolean getNotNull() {
        boolean required = false;
        String result = this.getNamedParameter("not-null");
        if (required && result == null) {
            this.bomb("not-null=\"???\" must be specified.");
        }
        if (result != null) {
            return Boolean.valueOf(result);
        }
        return null;
    }

    public Integer getLength() {
        boolean required = false;
        String result = this.getNamedParameter("length");
        if (required && result == null) {
            this.bomb("length=\"???\" must be specified.");
        }
        if (result != null) {
            try {
                return Integer.decode(result);
            }
            catch (NumberFormatException nfe) {
                this.bomb("length=\"" + result + "\" is not valid integer");
                throw nfe;
            }
        }
        return null;
    }

    public Boolean getUpdate() {
        boolean required = false;
        String result = this.getNamedParameter("update");
        if (required && result == null) {
            this.bomb("update=\"???\" must be specified.");
        }
        if (result != null) {
            return Boolean.valueOf(result);
        }
        return null;
    }

    public String getColumn() {
        boolean required = false;
        String result = this.getNamedParameter("column");
        if (required && result == null) {
            this.bomb("column=\"???\" must be specified.");
        }
        return result;
    }

    public String getFormula() {
        boolean required = false;
        String result = this.getNamedParameter("formula");
        if (required && result == null) {
            this.bomb("formula=\"???\" must be specified.");
        }
        return result;
    }

    protected void validateLocation() {
        if (this.isOnClass) {
            this.bomb("is not allowed on classes");
        }
        if (this.isOnConstructor) {
            this.bomb("is not allowed on constructors");
        }
        if (this.getContext().getTagsByName(NAME).length > 1) {
            this.bomb("is allowed only once");
        }
        if (ALLOWED_VALUES.size() > 1 && !ALLOWED_VALUES.contains(this.getValue())) {
            this.bomb("\"" + this.getValue() + "\" is not a valid value. Allowed values are ");
        }
        Set parameterNames = this.getNamedParameterMap().keySet();
        Iterator iterator = parameterNames.iterator();
        while (iterator.hasNext()) {
            String parameterName = (String)iterator.next();
            if (ALLOWED_PARAMETERS.contains(parameterName)) continue;
            this.bomb(parameterName + " is an invalid parameter name.");
        }
    }
}

