/*
 * Decompiled with CFR 0.152.
 */
package org.xdoclet.plugin.hibernate.qtags;

import com.thoughtworks.qdox.model.AbstractJavaEntity;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.xdoclet.XDocletTag;
import org.xdoclet.plugin.hibernate.qtags.HibernateKeyTag;

public class HibernateKeyTagImpl
extends XDocletTag
implements HibernateKeyTag {
    public static final String NAME = "hibernate.key";
    private static final List ALLOWED_PARAMETERS = Arrays.asList("foreign-key", "column", "");
    private static final List ALLOWED_VALUES = Arrays.asList("");

    public HibernateKeyTagImpl(String name, String value, AbstractJavaEntity entity, int lineNumber) {
        super(name, value, entity, lineNumber);
    }

    public String getForeignKey() {
        boolean required = false;
        String result = this.getNamedParameter("foreign-key");
        if (required && result == null) {
            this.bomb("foreign-key=\"???\" must be specified.");
        }
        return result;
    }

    public String getColumn() {
        boolean required = false;
        String result = this.getNamedParameter("column");
        if (required && result == null) {
            this.bomb("column=\"???\" must be specified.");
        }
        return result;
    }

    protected void validateLocation() {
        if (this.isOnClass) {
            this.bomb("is not allowed on classes");
        }
        if (this.isOnConstructor) {
            this.bomb("is not allowed on constructors");
        }
        if (ALLOWED_VALUES.size() > 1 && !ALLOWED_VALUES.contains(this.getValue())) {
            this.bomb("\"" + this.getValue() + "\" is not a valid value. Allowed values are ");
        }
        Set parameterNames = this.getNamedParameterMap().keySet();
        Iterator iterator = parameterNames.iterator();
        while (iterator.hasNext()) {
            String parameterName = (String)iterator.next();
            if (ALLOWED_PARAMETERS.contains(parameterName)) continue;
            this.bomb(parameterName + " is an invalid parameter name.");
        }
    }
}

