/*
 * Decompiled with CFR 0.152.
 */
package org.xdoclet.plugin.hibernate;

import com.thoughtworks.qdox.model.JavaClass;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.generama.JellyTemplateEngine;
import org.generama.MetadataProvider;
import org.generama.QDoxCapableMetadataProvider;
import org.generama.TemplateEngine;
import org.generama.WriterMapper;
import org.generama.defaults.QDoxPlugin;
import org.xdoclet.plugin.hibernate.qtags.TagLibrary;
import org.xdoclet.predicate.HasTag;

public class HibernateConfigPlugin
extends QDoxPlugin {
    private Collection allClasses;
    private String mappingExtension;
    private Properties props;
    private String jdbcdriver;
    private String jdbcurl;
    private String jdbcusername;
    private String jdbcpassword;
    private String jdbcpoolsize;
    private String jndidatasource;
    private String jndiurl;
    private String jndiclass;
    private String dialect;
    private String defaultschema;
    private String jndisessionfactoryname;
    private String userouterjoin;
    private String maxfetchdepth;
    private String jdbcfetchsize;
    private String jdbcbatchsize;
    private String jdbcbatchversioneddata;
    private String jdbcusescrollableresultset;
    private String jdbcusestreamsforbinary;
    private String jdbcusegetgeneratedkeys;
    private String usereflectionoptimizer;
    private String jdbcisolation;
    private String connectionprovider;
    private String cacheprovider;
    private String cacheuseminimalputs;
    private String cacheusequerycache;
    private String cachequerycachefactory;
    private String cacheregionprefix;
    private String transactionfactory;
    private String jtausertransaction;
    private String transactionmanagerlookup;
    private String querysubstitutions;
    private String showsql;
    private String hbm2ddlauto;

    public HibernateConfigPlugin(JellyTemplateEngine jellyTemplateEngine, QDoxCapableMetadataProvider metadataProvider, WriterMapper writerMapper) {
        super((TemplateEngine)jellyTemplateEngine, metadataProvider, writerMapper);
        this.setFilereplace("hibernate.cfg.xml");
        this.setMultioutput(false);
        this.setMappingextension(".hbm.xml");
        new TagLibrary((MetadataProvider)metadataProvider);
        this.props = new Properties();
    }

    public Collection getMappedClasses() {
        if (this.allClasses == null) {
            this.allClasses = this.metadataProvider.getMetadata();
        }
        return CollectionUtils.select((Collection)this.allClasses, (Predicate)new HasTag("hibernate.class", null, null, false));
    }

    public String getMappingPath(JavaClass clazz) {
        return clazz.getFullyQualifiedName().replace('.', '/') + this.mappingExtension;
    }

    public void setMappingextension(String mappingExtension) {
        this.mappingExtension = mappingExtension;
    }

    public void setProperties(String properties) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(properties);
            this.props.load(fis);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public Map getPropertyMap() {
        return this.props;
    }

    public String getJdbcdriver() {
        return this.jdbcdriver;
    }

    public void setJdbcdriver(String jdbcdriver) {
        this.jdbcdriver = jdbcdriver;
    }

    public String getJdbcurl() {
        return this.jdbcurl;
    }

    public void setJdbcurl(String jdbcurl) {
        this.jdbcurl = jdbcurl;
    }

    public String getJdbcusername() {
        return this.jdbcusername;
    }

    public void setJdbcusername(String jdbcusername) {
        this.jdbcusername = jdbcusername;
    }

    public String getJdbcpassword() {
        return this.jdbcpassword;
    }

    public void setJdbcpassword(String jdbcpassword) {
        this.jdbcpassword = jdbcpassword;
    }

    public String getJdbcpoolsize() {
        return this.jdbcpoolsize;
    }

    public void setJdbcpoolsize(String jdbcpoolsize) {
        this.jdbcpoolsize = jdbcpoolsize;
    }

    public String getJndidatasource() {
        return this.jndidatasource;
    }

    public void setJndidatasource(String jndidatasource) {
        this.jndidatasource = jndidatasource;
    }

    public String getJndiurl() {
        return this.jndiurl;
    }

    public void setJndiurl(String jndiurl) {
        this.jndiurl = jndiurl;
    }

    public String getJndiclass() {
        return this.jndiclass;
    }

    public void setJndiclass(String jndiclass) {
        this.jndiclass = jndiclass;
    }

    public String getDialect() {
        return this.dialect;
    }

    public void setDialect(String dialect) {
        this.dialect = dialect;
    }

    public String getDefaultschema() {
        return this.defaultschema;
    }

    public void setDefaultschema(String defaultschema) {
        this.defaultschema = defaultschema;
    }

    public String getJndisessionfactoryname() {
        return this.jndisessionfactoryname;
    }

    public void setJndisessionfactoryname(String jndisessionfactoryname) {
        this.jndisessionfactoryname = jndisessionfactoryname;
    }

    public String getUserouterjoin() {
        return this.userouterjoin;
    }

    public void setUserouterjoin(String userouterjoin) {
        this.userouterjoin = userouterjoin;
    }

    public String getMaxfetchdepth() {
        return this.maxfetchdepth;
    }

    public void setMaxfetchdepth(String maxfetchdepth) {
        this.maxfetchdepth = maxfetchdepth;
    }

    public String getJdbcfetchsize() {
        return this.jdbcfetchsize;
    }

    public void setJdbcfetchsize(String jdbcfetchsize) {
        this.jdbcfetchsize = jdbcfetchsize;
    }

    public String getJdbcbatchsize() {
        return this.jdbcbatchsize;
    }

    public void setJdbcbatchsize(String jdbcbatchsize) {
        this.jdbcbatchsize = jdbcbatchsize;
    }

    public String getJdbcbatchversioneddata() {
        return this.jdbcbatchversioneddata;
    }

    public void setJdbcbatchversioneddata(String jdbcbatchversioneddata) {
        this.jdbcbatchversioneddata = jdbcbatchversioneddata;
    }

    public String getJdbcusescrollableresultset() {
        return this.jdbcusescrollableresultset;
    }

    public void setJdbcusescrollableresultset(String jdbcusescrollableresultset) {
        this.jdbcusescrollableresultset = jdbcusescrollableresultset;
    }

    public String getJdbcusestreamsforbinary() {
        return this.jdbcusestreamsforbinary;
    }

    public void setJdbcusestreamsforbinary(String jdbcusestreamsforbinary) {
        this.jdbcusestreamsforbinary = jdbcusestreamsforbinary;
    }

    public String getJdbcusegetgeneratedkeys() {
        return this.jdbcusegetgeneratedkeys;
    }

    public void setJdbcusegetgeneratedkeys(String jdbcusegetgeneratedkeys) {
        this.jdbcusegetgeneratedkeys = jdbcusegetgeneratedkeys;
    }

    public String getUsereflectionoptimizer() {
        return this.usereflectionoptimizer;
    }

    public void setUsereflectionoptimizer(String usereflectionoptimizer) {
        this.usereflectionoptimizer = usereflectionoptimizer;
    }

    public String getJdbcisolation() {
        return this.jdbcisolation;
    }

    public void setJdbcisolation(String jdbcisolation) {
        this.jdbcisolation = jdbcisolation;
    }

    public String getConnectionprovider() {
        return this.connectionprovider;
    }

    public void setConnectionprovider(String connectionprovider) {
        this.connectionprovider = connectionprovider;
    }

    public String getCacheprovider() {
        return this.cacheprovider;
    }

    public void setCacheprovider(String cacheprovider) {
        this.cacheprovider = cacheprovider;
    }

    public String getCacheuseminimalputs() {
        return this.cacheuseminimalputs;
    }

    public void setCacheuseminimalputs(String cacheuseminimalputs) {
        this.cacheuseminimalputs = cacheuseminimalputs;
    }

    public String getCacheusequerycache() {
        return this.cacheusequerycache;
    }

    public void setCacheusequerycache(String cacheusequerycache) {
        this.cacheusequerycache = cacheusequerycache;
    }

    public String getCachequerycachefactory() {
        return this.cachequerycachefactory;
    }

    public void setCachequerycachefactory(String cachequerycachefactory) {
        this.cachequerycachefactory = cachequerycachefactory;
    }

    public String getCacheregionprefix() {
        return this.cacheregionprefix;
    }

    public void setCacheregionprefix(String cacheregionprefix) {
        this.cacheregionprefix = cacheregionprefix;
    }

    public String getTransactionfactory() {
        return this.transactionfactory;
    }

    public void setTransactionfactory(String transactionfactory) {
        this.transactionfactory = transactionfactory;
    }

    public String getJtausertransaction() {
        return this.jtausertransaction;
    }

    public void setJtausertransaction(String jtausertransaction) {
        this.jtausertransaction = jtausertransaction;
    }

    public String getTransactionmanagerlookup() {
        return this.transactionmanagerlookup;
    }

    public void setTransactionmanagerlookup(String transactionmanagerlookup) {
        this.transactionmanagerlookup = transactionmanagerlookup;
    }

    public String getQuerysubstitutions() {
        return this.querysubstitutions;
    }

    public void setQuerysubstitutions(String querysubstitutions) {
        this.querysubstitutions = querysubstitutions;
    }

    public String getShowsql() {
        return this.showsql;
    }

    public void setShowsql(String showsql) {
        this.showsql = showsql;
    }

    public String getHbm2ddlauto() {
        return this.hbm2ddlauto;
    }

    public void setHbm2ddlauto(String hbm2ddlauto) {
        this.hbm2ddlauto = hbm2ddlauto;
    }
}

