/*
 * Decompiled with CFR 0.152.
 */
package org.xdoclet.plugin.hibernate.qtags;

import com.thoughtworks.qdox.model.AbstractJavaEntity;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.xdoclet.XDocletTag;
import org.xdoclet.plugin.hibernate.qtags.HibernateIndexColumnTag;

public class HibernateIndexColumnTagImpl
extends XDocletTag
implements HibernateIndexColumnTag {
    public static final String NAME = "hibernate.index-column";
    private static final List ALLOWED_PARAMETERS = Arrays.asList("name", "unique-key", "index", "unique", "not-null", "length", "sql-type", "");
    private static final List ALLOWED_VALUES = Arrays.asList("");

    public HibernateIndexColumnTagImpl(String name, String value, AbstractJavaEntity entity, int lineNumber) {
        super(name, value, entity, lineNumber);
    }

    public String getName_() {
        boolean required = true;
        String result = this.getNamedParameter("name");
        if (required && result == null) {
            this.bomb("name=\"???\" must be specified.");
        }
        return result;
    }

    public String getUniqueKey() {
        boolean required = false;
        String result = this.getNamedParameter("unique-key");
        if (required && result == null) {
            this.bomb("unique-key=\"???\" must be specified.");
        }
        return result;
    }

    public String getIndex() {
        boolean required = false;
        String result = this.getNamedParameter("index");
        if (required && result == null) {
            this.bomb("index=\"???\" must be specified.");
        }
        return result;
    }

    public Boolean getUnique() {
        boolean required = false;
        String result = this.getNamedParameter("unique");
        if (required && result == null) {
            this.bomb("unique=\"???\" must be specified.");
        }
        if (result != null) {
            return Boolean.valueOf(result);
        }
        return null;
    }

    public Boolean getNotNull() {
        boolean required = false;
        String result = this.getNamedParameter("not-null");
        if (required && result == null) {
            this.bomb("not-null=\"???\" must be specified.");
        }
        if (result != null) {
            return Boolean.valueOf(result);
        }
        return null;
    }

    public Integer getLength() {
        boolean required = false;
        String result = this.getNamedParameter("length");
        if (required && result == null) {
            this.bomb("length=\"???\" must be specified.");
        }
        if (result != null) {
            try {
                return Integer.decode(result);
            }
            catch (NumberFormatException nfe) {
                this.bomb("length=\"" + result + "\" is not valid integer");
                throw nfe;
            }
        }
        return null;
    }

    public String getSqlType() {
        boolean required = false;
        String result = this.getNamedParameter("sql-type");
        if (required && result == null) {
            this.bomb("sql-type=\"???\" must be specified.");
        }
        return result;
    }

    protected void validateLocation() {
        if (this.isOnClass) {
            this.bomb("is not allowed on classes");
        }
        if (this.isOnField) {
            this.bomb("is not allowed on fields");
        }
        if (this.isOnConstructor) {
            this.bomb("is not allowed on constructors");
        }
        if (ALLOWED_VALUES.size() > 1 && !ALLOWED_VALUES.contains(this.getValue())) {
            this.bomb("\"" + this.getValue() + "\" is not a valid value. Allowed values are ");
        }
        Set parameterNames = this.getNamedParameterMap().keySet();
        Iterator iterator = parameterNames.iterator();
        while (iterator.hasNext()) {
            String parameterName = (String)iterator.next();
            if (ALLOWED_PARAMETERS.contains(parameterName)) continue;
            this.bomb(parameterName + " is an invalid parameter name.");
        }
    }
}

