/*
 * Decompiled with CFR 0.152.
 */
package org.xdoclet.plugin.hibernate.qtags;

import com.thoughtworks.qdox.model.AbstractJavaEntity;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.xdoclet.XDocletTag;
import org.xdoclet.plugin.hibernate.qtags.HibernateIdTag;

public class HibernateIdTagImpl
extends XDocletTag
implements HibernateIdTag {
    public static final String NAME = "hibernate.id";
    private static final List ALLOWED_PARAMETERS = Arrays.asList("generator-class", "unsaved-value", "type", "length", "column", "");
    private static final List ALLOWED_VALUES = Arrays.asList("");

    public HibernateIdTagImpl(String name, String value, AbstractJavaEntity entity, int lineNumber) {
        super(name, value, entity, lineNumber);
    }

    public String getGeneratorClass() {
        boolean required = true;
        String result = this.getNamedParameter("generator-class");
        if (required && result == null) {
            this.bomb("generator-class=\"???\" must be specified.");
        }
        if (!(result == null || result.equals("uuid.hex") || result.equals("uuid.string") || result.equals("increment") || result.equals("assigned") || result.equals("native") || result.equals("identity") || result.equals("sequence") || result.equals("hilo") || result.equals("seqhilo") || result.equals("foreign"))) {
            this.bomb("generator-class=\"" + result + "\" is an invalid parameter value.");
        }
        return result;
    }

    public String getUnsavedValue() {
        boolean required = false;
        String result = this.getNamedParameter("unsaved-value");
        if (required && result == null) {
            this.bomb("unsaved-value=\"???\" must be specified.");
        }
        return result;
    }

    public String getType() {
        boolean required = false;
        String result = this.getNamedParameter("type");
        if (required && result == null) {
            this.bomb("type=\"???\" must be specified.");
        }
        return result;
    }

    public Integer getLength() {
        boolean required = false;
        String result = this.getNamedParameter("length");
        if (required && result == null) {
            this.bomb("length=\"???\" must be specified.");
        }
        if (result != null) {
            try {
                return Integer.decode(result);
            }
            catch (NumberFormatException nfe) {
                this.bomb("length=\"" + result + "\" is not valid integer");
                throw nfe;
            }
        }
        return null;
    }

    public String getColumn() {
        boolean required = false;
        String result = this.getNamedParameter("column");
        if (required && result == null) {
            this.bomb("column=\"???\" must be specified.");
        }
        return result;
    }

    protected void validateLocation() {
        if (this.isOnClass) {
            this.bomb("is not allowed on classes");
        }
        if (this.isOnConstructor) {
            this.bomb("is not allowed on constructors");
        }
        if (ALLOWED_VALUES.size() > 1 && !ALLOWED_VALUES.contains(this.getValue())) {
            this.bomb("\"" + this.getValue() + "\" is not a valid value. Allowed values are ");
        }
        Set parameterNames = this.getNamedParameterMap().keySet();
        Iterator iterator = parameterNames.iterator();
        while (iterator.hasNext()) {
            String parameterName = (String)iterator.next();
            if (ALLOWED_PARAMETERS.contains(parameterName)) continue;
            this.bomb(parameterName + " is an invalid parameter name.");
        }
        this.getGeneratorClass();
    }
}

