/*
 * Decompiled with CFR 0.152.
 */
package org.xdoclet.plugin.hibernate.qtags;

import com.thoughtworks.qdox.model.AbstractJavaEntity;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.xdoclet.XDocletTag;
import org.xdoclet.plugin.hibernate.qtags.HibernateDiscriminatorTag;

public class HibernateDiscriminatorTagImpl
extends XDocletTag
implements HibernateDiscriminatorTag {
    public static final String NAME = "hibernate.discriminator";
    private static final List ALLOWED_PARAMETERS = Arrays.asList("column", "force", "type", "not-null", "length", "");
    private static final List ALLOWED_VALUES = Arrays.asList("");

    public HibernateDiscriminatorTagImpl(String name, String value, AbstractJavaEntity entity, int lineNumber) {
        super(name, value, entity, lineNumber);
    }

    public String getColumn() {
        boolean required = false;
        String result = this.getNamedParameter("column");
        if (required && result == null) {
            this.bomb("column=\"???\" must be specified.");
        }
        if (result == null) {
            result = "class";
        }
        return result;
    }

    public Boolean getForce() {
        boolean required = false;
        String result = this.getNamedParameter("force");
        if (required && result == null) {
            this.bomb("force=\"???\" must be specified.");
        }
        if (result != null) {
            return Boolean.valueOf(result);
        }
        return null;
    }

    public String getType() {
        boolean required = false;
        String result = this.getNamedParameter("type");
        if (required && result == null) {
            this.bomb("type=\"???\" must be specified.");
        }
        return result;
    }

    public Boolean getNotNull() {
        boolean required = false;
        String result = this.getNamedParameter("not-null");
        if (required && result == null) {
            this.bomb("not-null=\"???\" must be specified.");
        }
        if (result != null) {
            return Boolean.valueOf(result);
        }
        return null;
    }

    public Integer getLength() {
        boolean required = false;
        String result = this.getNamedParameter("length");
        if (required && result == null) {
            this.bomb("length=\"???\" must be specified.");
        }
        if (result != null) {
            try {
                return Integer.decode(result);
            }
            catch (NumberFormatException nfe) {
                this.bomb("length=\"" + result + "\" is not valid integer");
                throw nfe;
            }
        }
        return null;
    }

    protected void validateLocation() {
        if (this.isOnField) {
            this.bomb("is not allowed on fields");
        }
        if (this.isOnConstructor) {
            this.bomb("is not allowed on constructors");
        }
        if (this.isOnMethod) {
            this.bomb("is not allowed on methods");
        }
        if (ALLOWED_VALUES.size() > 1 && !ALLOWED_VALUES.contains(this.getValue())) {
            this.bomb("\"" + this.getValue() + "\" is not a valid value. Allowed values are ");
        }
        Set parameterNames = this.getNamedParameterMap().keySet();
        Iterator iterator = parameterNames.iterator();
        while (iterator.hasNext()) {
            String parameterName = (String)iterator.next();
            if (ALLOWED_PARAMETERS.contains(parameterName)) continue;
            this.bomb(parameterName + " is an invalid parameter name.");
        }
        this.getColumn();
        this.getForce();
    }
}

