/*
 * Decompiled with CFR 0.152.
 */
package org.xdoclet.plugin.externalizer;

import com.thoughtworks.qdox.model.JavaClass;
import org.generama.MetadataProvider;
import org.generama.QDoxCapableMetadataProvider;
import org.generama.TemplateEngine;
import org.generama.VelocityTemplateEngine;
import org.generama.WriterMapper;
import org.generama.defaults.QDoxPlugin;
import org.xdoclet.plugin.externalizer.qtags.MsgMessageTagImpl;
import org.xdoclet.plugin.externalizer.qtags.TagLibrary;

public class MessageBundlePlugin
extends QDoxPlugin {
    private String lang;
    private String country;
    private String variant;

    public MessageBundlePlugin(VelocityTemplateEngine templateEngine, QDoxCapableMetadataProvider metadataProvider, WriterMapper writerMapper) {
        super((TemplateEngine)templateEngine, metadataProvider, writerMapper);
        this.setFileregex("\\.java");
        this.setFilereplace("\\" + this.getBundleKey() + ".properties");
        this.setMultioutput(true);
        new TagLibrary((MetadataProvider)metadataProvider);
    }

    public String getLang() {
        return this.lang;
    }

    public String getCountry() {
        return this.country;
    }

    public String getVariant() {
        return this.variant;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public void setVariant(String variant) {
        this.variant = variant;
    }

    public String getBundleKey() {
        StringBuffer sb = new StringBuffer();
        if (this.getLang() == null) {
            return "";
        }
        sb.append(this.getLang());
        if (this.getCountry() == null) {
            return sb.toString();
        }
        sb.append("_");
        sb.append(this.getCountry());
        if (this.getVariant() != null) {
            sb.append("_");
            sb.append(this.getVariant());
        }
        return sb.toString();
    }

    public boolean messageApplicable(MsgMessageTagImpl tag) {
        if (this.getLang() == null) {
            return tag.getLang() == null;
        }
        if (this.getLang().equals(tag.getLang())) {
            if (this.getCountry() == null) {
                return tag.getCountry() == null;
            }
            if (this.getCountry().equals(tag.getCountry())) {
                if (this.getVariant() == null) {
                    return tag.getVariant() == null;
                }
                return this.getVariant().equals(tag.getVariant());
            }
        }
        return false;
    }

    public boolean shouldGenerate(Object metadata) {
        JavaClass clazz = (JavaClass)metadata;
        return clazz.getTagByName("msg.bundle") != null;
    }
}

