/*
 * Decompiled with CFR 0.152.
 */
package website.dachuan.migration.spring;

import java.io.Closeable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.core.annotation.Order;
import org.springframework.util.StringUtils;
import website.dachuan.migration.MigrationProcess;
import website.dachuan.migration.props.MigrationProps;
import website.dachuan.migration.service.IDBOperation;
import website.dachuan.migration.service.ISchemaHistoryService;
import website.dachuan.migration.service.ISqlScriptRunner;
import website.dachuan.migration.utils.DatabaseIdProvider;

@Order(value=1)
public class MigrationRunner
implements ApplicationRunner,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(MigrationRunner.class);
    private final Map<String, DataSource> dataSource;
    private final MigrationProps props;
    private final ISqlScriptRunner scriptRunner;
    private final ISchemaHistoryService schemaHistoryService;
    private final Map<String, IDBOperation> idbOperationMap;
    private MigrationProcess process;

    public MigrationRunner(Map<String, DataSource> dataSource, MigrationProps props, ISqlScriptRunner scriptRunner, ISchemaHistoryService schemaHistoryService, Map<String, IDBOperation> idbOperationMap) {
        this.dataSource = dataSource;
        this.props = props;
        this.scriptRunner = scriptRunner;
        this.schemaHistoryService = schemaHistoryService;
        this.idbOperationMap = idbOperationMap;
    }

    public void run(ApplicationArguments args) throws Exception {
        if (this.dataSource == null || this.dataSource.keySet().size() == 0) {
            return;
        }
        this.process = new MigrationProcess(this.props, this.idbOperationMap, this.scriptRunner, this.schemaHistoryService);
        Collection r = null;
        if (this.props.getTenantData().isEnabled()) {
            String primaryDataBaseId = this.props.getTenantData().getPrimaryDataBaseId();
            String tenantTable = this.props.getTenantData().getTenantTableName();
            String tenantTableId = this.props.getTenantData().getTenantTableIdColumn();
            String tenantJdbcUrl = this.props.getTenantData().getJdbcUrlColumn();
            StringBuilder sql = new StringBuilder("select ").append(tenantTableId).append(" as tenantId, ").append(tenantJdbcUrl).append(" as url ").append(" from ").append(tenantTable);
            DataSource primary = this.dataSource.get(primaryDataBaseId);
            if (primary == null) {
                throw new IllegalArgumentException("\u4e3b\u6570\u636e\u6e90\u83b7\u53d6\u5931\u8d25\uff01");
            }
            try {
                r = this.scriptRunner.runScript(primary.getConnection(), sql.toString(), new Object[0]);
            }
            catch (Exception e) {
                log.error("\u4ece\u4e3b\u6570\u636e\u6e90\u4e2d\u83b7\u53d6\u79df\u6237\u4fe1\u606f\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }
        for (Map.Entry<String, DataSource> e : this.dataSource.entrySet()) {
            List<String> tenantIds = new ArrayList<String>();
            if (this.props.getTenantData().isEnabled() && r != null) {
                tenantIds = this.props.getTenantData().getPrimaryDataBaseId().equals(e.getKey()) ? r.stream().filter(stringObjectMap -> StringUtils.isEmpty(stringObjectMap.get("url"))).map(stringObjectMap -> {
                    Object tenantId = stringObjectMap.get("tenantId");
                    if (tenantId != null) {
                        return tenantId.toString();
                    }
                    return null;
                }).filter(Objects::nonNull).collect(Collectors.toList()) : r.stream().filter(stringObjectMap -> {
                    try {
                        return !StringUtils.isEmpty(stringObjectMap.get("url")) && stringObjectMap.get("url").equals(((DataSource)e.getValue()).getConnection().getMetaData().getURL());
                    }
                    catch (SQLException sqlException) {
                        log.error(log.getName(), (Throwable)sqlException);
                        return false;
                    }
                }).map(stringObjectMap -> {
                    Object tenantId = stringObjectMap.get("tenantId");
                    if (tenantId != null) {
                        return tenantId.toString();
                    }
                    return null;
                }).filter(Objects::nonNull).collect(Collectors.toList());
            } else {
                log.error("\u7cfb\u7edf\u5f00\u542f\u591a\u79df\u6237\u6570\u636e\u4f46\u662f\u4e3b\u6570\u636e\u672a\u521d\u59cb\u5316\uff0c\u672a\u67e5\u8be2\u5230\u79df\u6237\u4fe1\u606f\u65e0\u6cd5\u8fdb\u884c\u591a\u79df\u6237\u6570\u636e\u5904\u7406\uff01");
            }
            this.runMigration(e.getValue(), tenantIds);
        }
        this.dataSource.clear();
    }

    private void runMigration(DataSource dataSource, List<String> tenantIds) {
        DatabaseIdProvider.DatabaseId databaseId;
        Connection conn;
        try {
            conn = dataSource.getConnection();
            String databaseProductName = DatabaseIdProvider.getDatabaseId((Connection)conn);
            databaseId = DatabaseIdProvider.DatabaseId.valueOf((String)databaseProductName);
        }
        catch (SQLException e) {
            log.error("", (Throwable)e);
            return;
        }
        try {
            if (databaseId.ddlTransaction) {
                conn.setAutoCommit(false);
            }
            this.process.exec(conn, tenantIds);
            if (databaseId.ddlTransaction) {
                conn.commit();
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            try {
                if (databaseId.ddlTransaction) {
                    conn.rollback();
                }
                conn.close();
            }
            catch (SQLException sqlException) {
                log.error("", (Throwable)sqlException);
            }
            this.close();
            System.exit(0);
        }
    }

    @Override
    public void close() {
        this.dataSource.clear();
    }
}

