/*
 * Decompiled with CFR 0.152.
 */
package website.dachuan.migration.spring;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import website.dachuan.migration.MigrationRun;
import website.dachuan.migration.MigrationTenantDataRun;
import website.dachuan.migration.dao.DBOperationDao;
import website.dachuan.migration.dao.SchemaHistoryDao;
import website.dachuan.migration.dao.TenantDao;
import website.dachuan.migration.service.IDBOperation;
import website.dachuan.migration.service.ISchemaHistoryService;
import website.dachuan.migration.service.ISqlScriptRunner;
import website.dachuan.migration.service.ITenantService;
import website.dachuan.migration.service.impl.SchemaHistoryService;
import website.dachuan.migration.service.impl.SqlScriptRunner;
import website.dachuan.migration.service.impl.TenantService;
import website.dachuan.migration.service.task.handles.TaskHandle;
import website.dachuan.migration.spring.MigrationRunner;
import website.dachuan.migration.spring.props.MigrationAutoProps;

@Configuration
@EnableConfigurationProperties(value={MigrationAutoProps.class})
@ConditionalOnProperty(prefix="migration", name={"enabled"}, havingValue="true")
public class MigrationConfig {
    private static final Logger log = LoggerFactory.getLogger(MigrationConfig.class);
    private final MigrationAutoProps autoProps;
    private final ApplicationContext applicationContext;
    private final SchemaHistoryService schemaHistoryService = new SchemaHistoryService(new SchemaHistoryDao());
    private final ITenantService tenantService = new TenantService(new TenantDao());
    private final SqlScriptRunner sqlScriptRunner = new SqlScriptRunner();
    private final DBOperationDao dbOperationDao = new DBOperationDao();
    private final TaskHandle taskHandle;

    @Autowired
    public MigrationConfig(ApplicationContext applicationContext, MigrationAutoProps props) {
        this.autoProps = props;
        this.taskHandle = new TaskHandle(props.getSchema(), (ISchemaHistoryService)this.schemaHistoryService, (ISqlScriptRunner)this.sqlScriptRunner);
        this.applicationContext = applicationContext;
    }

    @Bean
    MigrationRunner createMigrationRunner() {
        return new MigrationRunner(this.applicationContext, this.autoProps.getSchema(), this.tenantService, this.migrationRun(), this.migrationTenantDataRun());
    }

    @Bean
    MigrationRun migrationRun() {
        return new MigrationRun(this.autoProps.getSchema(), (ISchemaHistoryService)this.schemaHistoryService, (ISqlScriptRunner)this.sqlScriptRunner, this.taskHandle, (IDBOperation)this.dbOperationDao);
    }

    @Bean
    MigrationTenantDataRun migrationTenantDataRun() {
        return new MigrationTenantDataRun(this.autoProps.getSchema(), this.taskHandle);
    }
}

