/*
 * Decompiled with CFR 0.152.
 */
package website.dachuan.migration.spring;

import java.io.Closeable;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.Order;
import website.dachuan.migration.DynamicRoutingDataSource;
import website.dachuan.migration.MigrationRun;
import website.dachuan.migration.MigrationTenantDataRun;
import website.dachuan.migration.entity.TenantEntity;
import website.dachuan.migration.props.MigrationProps;
import website.dachuan.migration.service.ITenantService;
import website.dachuan.migration.utils.Files;

@Order(value=1)
public class MigrationRunner
implements ApplicationRunner,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(MigrationRunner.class);
    private final MigrationProps props;
    private final ITenantService tenantService;
    private final MigrationRun migrationRun;
    private final MigrationTenantDataRun migrationTenantDataRunRun;
    private final Map<String, DataSource> dataSourceMap = new HashMap<String, DataSource>();

    public MigrationRunner(ApplicationContext applicationContext, MigrationProps props, ITenantService tenantService, MigrationRun migrationRun, MigrationTenantDataRun migrationTenantDataRunRun) {
        this.props = props;
        this.tenantService = tenantService;
        this.migrationRun = migrationRun;
        this.migrationTenantDataRunRun = migrationTenantDataRunRun;
        Map dssMap = applicationContext.getBeansOfType(DataSource.class);
        if (dssMap.isEmpty()) {
            return;
        }
        try {
            Class.forName("com.baomidou.dynamic.datasource.DynamicRoutingDataSource", false, this.getClass().getClassLoader());
            for (Map.Entry entry : dssMap.entrySet()) {
                if (entry.getValue() instanceof com.baomidou.dynamic.datasource.DynamicRoutingDataSource) {
                    this.dataSourceMap.putAll(((com.baomidou.dynamic.datasource.DynamicRoutingDataSource)entry.getValue()).getDataSources());
                    continue;
                }
                if (entry.getValue() instanceof DynamicRoutingDataSource) {
                    this.dataSourceMap.putAll(((DynamicRoutingDataSource)entry.getValue()).getDataSources());
                    continue;
                }
                this.dataSourceMap.put((String)entry.getKey(), (DataSource)entry.getValue());
            }
        }
        catch (ClassNotFoundException e) {
            log.debug("com.baomidou.dynamic.datasource.DynamicRoutingDataSource ClassNotFoundException");
            for (Map.Entry entry : dssMap.entrySet()) {
                if (entry.getValue() instanceof DynamicRoutingDataSource) {
                    this.dataSourceMap.putAll(((DynamicRoutingDataSource)entry.getValue()).getDataSources());
                    continue;
                }
                this.dataSourceMap.put((String)entry.getKey(), (DataSource)entry.getValue());
            }
        }
    }

    public void run(ApplicationArguments args) throws Exception {
        Files.cleanTemp();
        if (this.dataSourceMap.keySet().size() == 0) {
            return;
        }
        Files.copyFile((String)this.props.getScriptDirPath());
        Files.copyFile((String)this.props.getTenantData().getScriptDirPath());
        for (Map.Entry<String, DataSource> e : this.dataSourceMap.entrySet()) {
            try {
                this.migrationRun.run(e.getValue().getConnection());
            }
            catch (Exception exception) {
                log.error("migrationRun error", (Throwable)exception);
                System.exit(0);
            }
        }
        if (!this.props.getTenantData().isEnabled()) {
            this.dataSourceMap.clear();
            return;
        }
        String primaryDataBaseId = this.props.getTenantData().getPrimaryDataBaseId();
        String tenantTable = this.props.getTenantData().getTenantTableName();
        String tenantTableId = this.props.getTenantData().getTenantTableIdColumn();
        String tenantJdbcUrl = this.props.getTenantData().getJdbcUrlColumn();
        DataSource primary = this.dataSourceMap.get(primaryDataBaseId);
        if (primary == null) {
            throw new RuntimeException("\u591a\u79df\u6237\u6a21\u5f0f\u4e0b\uff0c\u672a\u67e5\u8be2\u5230\u4e3b\u6570\u636e\u6e90\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u9879\u662f\u5426\u6b63\u786e\uff01");
        }
        if (primary.getConnection() == null) {
            throw new RuntimeException("\u591a\u79df\u6237\u6a21\u5f0f\u4e0b\uff0c\u4e3b\u6570\u636e\u6e90\u8fde\u63a5\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u9879\u662f\u5426\u6b63\u786e\uff01");
        }
        this.migrationTenantDataRunRun.run(primary.getConnection(), null, true);
        List tenantEntities = this.tenantService.queryTenantInfo(primary.getConnection(), tenantTable, tenantTableId, tenantJdbcUrl);
        if (tenantEntities == null || tenantEntities.size() < 1) {
            this.dataSourceMap.clear();
            return;
        }
        for (Map.Entry<String, DataSource> e : this.dataSourceMap.entrySet()) {
            List tenantIds = this.props.getTenantData().getPrimaryDataBaseId().equals(e.getKey()) ? tenantEntities.stream().filter(t -> !t.isIndependentDatabase()).filter(t -> t.getTenantId() != null && t.getTenantId().length() > 0).map(TenantEntity::getTenantId).collect(Collectors.toList()) : tenantEntities.stream().filter(TenantEntity::isIndependentDatabase).filter(t -> t.getTenantId() != null && t.getTenantId().length() > 0).filter(t -> {
                try {
                    return t.getUrl().equals(((DataSource)e.getValue()).getConnection().getMetaData().getURL());
                }
                catch (SQLException sqlException) {
                    log.error(log.getName(), (Throwable)sqlException);
                    return false;
                }
            }).map(TenantEntity::getTenantId).collect(Collectors.toList());
            this.migrationTenantDataRunRun.run(e.getValue().getConnection(), tenantIds, false);
        }
        this.dataSourceMap.clear();
    }

    @Override
    public void close() {
        this.dataSourceMap.clear();
    }

    @PreDestroy
    public void destroy() {
        boolean t = Files.deleteTemp();
        if (!t) {
            log.error("migration \u6587\u4ef6\u5939\u5220\u9664\u5931\u8d25\uff01");
        }
    }
}

