package website.dachuan.migration.spring;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import website.dachuan.migration.MigrationRun;
import website.dachuan.migration.MigrationTenantDataRun;
import website.dachuan.migration.dao.DBOperationDao;
import website.dachuan.migration.dao.SchemaHistoryDao;
import website.dachuan.migration.dao.TenantDao;
import website.dachuan.migration.service.ITenantService;
import website.dachuan.migration.service.SqlScriptRunner;
import website.dachuan.migration.service.impl.SchemaHistoryService;
import website.dachuan.migration.service.impl.TenantService;
import website.dachuan.migration.service.task.handles.TaskHandle;
import website.dachuan.migration.spring.props.MigrationAutoProps;

/**
 * @author yqb22
 */
@Configuration
@EnableConfigurationProperties(MigrationAutoProps.class)
@ConditionalOnProperty(prefix = "migration", name = "enabled", havingValue = "true")
@Slf4j
public class MigrationConfig {
    private final MigrationAutoProps autoProps;
    private final ApplicationContext applicationContext;
    private final SchemaHistoryService schemaHistoryService = new SchemaHistoryService(new SchemaHistoryDao());
    private final ITenantService tenantService = new TenantService(new TenantDao());
    private final SqlScriptRunner sqlScriptRunner = new SqlScriptRunner();
    private final DBOperationDao dbOperationDao = new DBOperationDao();
    private final TaskHandle taskHandle;

    @Autowired
    public MigrationConfig(ApplicationContext applicationContext, MigrationAutoProps props) {
        this.autoProps = props;
        this.taskHandle = new TaskHandle(props.getSchema(), schemaHistoryService, sqlScriptRunner);
        this.applicationContext = applicationContext;
    }

    @Bean
    MigrationRunner createMigrationRunner() {
        return new MigrationRunner(applicationContext, autoProps.getSchema(), tenantService, migrationRun(), migrationTenantDataRun());
    }

    @Bean
    MigrationRun migrationRun() {
        return new MigrationRun(autoProps.getSchema(), schemaHistoryService, sqlScriptRunner, taskHandle, dbOperationDao);
    }

    @Bean
    MigrationTenantDataRun migrationTenantDataRun() {
        return new MigrationTenantDataRun(autoProps.getSchema(), taskHandle);
    }
}
