/*
 * Decompiled with CFR 0.152.
 */
package website.dachuan.migration.spring;

import java.io.Closeable;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.Order;
import org.springframework.util.StringUtils;
import website.dachuan.migration.DynamicRoutingDataSource;
import website.dachuan.migration.MigrationRun;
import website.dachuan.migration.props.MigrationProps;
import website.dachuan.migration.service.ISqlScriptRunner;
import website.dachuan.migration.utils.Files;

@Order(value=1)
public class MigrationRunner
implements ApplicationRunner,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(MigrationRunner.class);
    private final MigrationProps props;
    private final ISqlScriptRunner scriptRunner;
    private final MigrationRun migrationRun;
    private final Map<String, DataSource> dataSourceMap = new HashMap<String, DataSource>();

    public MigrationRunner(ApplicationContext applicationContext, MigrationProps props, ISqlScriptRunner scriptRunner, MigrationRun migrationRun) {
        this.props = props;
        this.scriptRunner = scriptRunner;
        this.migrationRun = migrationRun;
        Map dssMap = applicationContext.getBeansOfType(DataSource.class);
        if (dssMap.isEmpty()) {
            return;
        }
        try {
            Class.forName("com.baomidou.dynamic.datasource.DynamicRoutingDataSource", false, this.getClass().getClassLoader());
            for (Map.Entry entry : dssMap.entrySet()) {
                this.dataSourceMap.putAll(((com.baomidou.dynamic.datasource.DynamicRoutingDataSource)entry.getValue()).getDataSources());
            }
        }
        catch (ClassNotFoundException e) {
            log.debug("com.baomidou.dynamic.datasource.DynamicRoutingDataSource ClassNotFoundException");
            for (Map.Entry entry : dssMap.entrySet()) {
                if (entry.getValue() instanceof DynamicRoutingDataSource) {
                    this.dataSourceMap.putAll(((DynamicRoutingDataSource)entry.getValue()).getDataSources());
                    continue;
                }
                this.dataSourceMap.put((String)entry.getKey(), (DataSource)entry.getValue());
            }
        }
    }

    public void run(ApplicationArguments args) throws IOException {
        Files.cleanTemp();
        if (this.dataSourceMap.keySet().size() == 0) {
            return;
        }
        Files.copyFile((String)this.props.getScriptDirPath());
        Files.copyFile((String)this.props.getTenantData().getScriptDirPath());
        Collection r = null;
        if (this.props.getTenantData().isEnabled()) {
            String primaryDataBaseId = this.props.getTenantData().getPrimaryDataBaseId();
            String tenantTable = this.props.getTenantData().getTenantTableName();
            String tenantTableId = this.props.getTenantData().getTenantTableIdColumn();
            String tenantJdbcUrl = this.props.getTenantData().getJdbcUrlColumn();
            StringBuilder sql = new StringBuilder("select ").append(tenantTableId).append(" as tenantId, ").append(tenantJdbcUrl).append(" as url ").append(" from ").append(tenantTable);
            DataSource primary = this.dataSourceMap.get(primaryDataBaseId);
            if (primary == null) {
                throw new IllegalArgumentException("\u4e3b\u6570\u636e\u6e90\u83b7\u53d6\u5931\u8d25\uff01");
            }
            try {
                r = this.scriptRunner.runScript(primary.getConnection(), sql.toString(), new Object[0]);
            }
            catch (Exception e) {
                log.error("\u4ece\u4e3b\u6570\u636e\u6e90\u4e2d\u83b7\u53d6\u79df\u6237\u4fe1\u606f\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }
        for (Map.Entry<String, DataSource> e : this.dataSourceMap.entrySet()) {
            List<Object> tenantIds = new ArrayList();
            if (this.props.getTenantData().isEnabled() && r != null) {
                tenantIds = this.props.getTenantData().getPrimaryDataBaseId().equals(e.getKey()) ? r.stream().filter(stringObjectMap -> StringUtils.isEmpty(stringObjectMap.get("url"))).map(stringObjectMap -> {
                    Object tenantId = stringObjectMap.get("tenantId");
                    if (tenantId != null) {
                        return tenantId.toString();
                    }
                    return null;
                }).filter(Objects::nonNull).collect(Collectors.toList()) : r.stream().filter(stringObjectMap -> {
                    try {
                        return !StringUtils.isEmpty(stringObjectMap.get("url")) && stringObjectMap.get("url").equals(((DataSource)e.getValue()).getConnection().getMetaData().getURL());
                    }
                    catch (SQLException sqlException) {
                        log.error(log.getName(), (Throwable)sqlException);
                        return false;
                    }
                }).map(stringObjectMap -> {
                    Object tenantId = stringObjectMap.get("tenantId");
                    if (tenantId != null) {
                        return tenantId.toString();
                    }
                    return null;
                }).filter(Objects::nonNull).collect(Collectors.toList());
            }
            try {
                this.migrationRun.run(e.getValue(), tenantIds);
            }
            catch (Exception exception) {
                log.error("migrationRun error", (Throwable)exception);
                System.exit(0);
            }
        }
        this.dataSourceMap.clear();
    }

    @Override
    public void close() {
        this.dataSourceMap.clear();
    }

    @PreDestroy
    public void destroy() {
        boolean t = Files.deleteTemp();
        if (!t) {
            log.error("migration \u6587\u4ef6\u5939\u5220\u9664\u5931\u8d25\uff01");
        }
    }
}

