/*
 * Decompiled with CFR 0.152.
 */
package website.dachuan.migration.spring;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import website.dachuan.migration.MigrationRun;
import website.dachuan.migration.dao.DBOperationDao;
import website.dachuan.migration.dao.SchemaHistoryDao;
import website.dachuan.migration.service.IDBOperation;
import website.dachuan.migration.service.ISchemaHistoryService;
import website.dachuan.migration.service.ISqlScriptRunner;
import website.dachuan.migration.service.SchemaHistoryService;
import website.dachuan.migration.service.SqlScriptRunner;
import website.dachuan.migration.spring.MigrationRunner;
import website.dachuan.migration.spring.props.MigrationAutoProps;

@Configuration
@EnableConfigurationProperties(value={MigrationAutoProps.class})
@ConditionalOnProperty(prefix="migration", name={"enabled"}, havingValue="true")
public class MigrationConfig {
    private static final Logger log = LoggerFactory.getLogger(MigrationConfig.class);
    private final MigrationAutoProps autoProps;
    private final ApplicationContext applicationContext;

    @Autowired
    public MigrationConfig(ApplicationContext applicationContext, MigrationAutoProps props) {
        this.autoProps = props;
        this.applicationContext = applicationContext;
    }

    @Bean
    MigrationRunner createMigrationRunner() {
        return new MigrationRunner(this.applicationContext, this.autoProps.getSchema(), (ISqlScriptRunner)new SqlScriptRunner(), this.migrationRun());
    }

    @Bean
    MigrationRun migrationRun() {
        return new MigrationRun(this.autoProps.getSchema(), (ISchemaHistoryService)new SchemaHistoryService(new SchemaHistoryDao()), (ISqlScriptRunner)new SqlScriptRunner(), (IDBOperation)new DBOperationDao());
    }
}

