package website.dachuan.migration.spring;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import website.dachuan.migration.MigrationRun;
import website.dachuan.migration.dao.DBOperationDao;
import website.dachuan.migration.dao.SchemaHistoryDao;
import website.dachuan.migration.service.SchemaHistoryService;
import website.dachuan.migration.service.SqlScriptRunner;
import website.dachuan.migration.spring.props.MigrationAutoProps;

@Configuration
@EnableConfigurationProperties(MigrationAutoProps.class)
@ConditionalOnProperty(prefix = "migration", name = "enabled", havingValue = "true")
@Slf4j
public class MigrationConfig {
    private final MigrationAutoProps autoProps;
    private final ApplicationContext applicationContext;

    @Autowired
    public MigrationConfig(ApplicationContext applicationContext, MigrationAutoProps props) {
        this.autoProps = props;
        this.applicationContext = applicationContext;
    }

    @Bean
    MigrationRunner createMigrationRunner() {
        return new MigrationRunner(applicationContext, autoProps.getSchema(), new SqlScriptRunner(), migrationRun());
    }

    @Bean
    MigrationRun migrationRun() {
        return new MigrationRun(autoProps.getSchema(), new SchemaHistoryService(new SchemaHistoryDao()), new SqlScriptRunner(), new DBOperationDao());
    }

}
