package website.dachuan.migration.spring;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import website.dachuan.migration.MigrationRun;
import website.dachuan.migration.dao.SchemaHistoryDao;
import website.dachuan.migration.dao.mysql.MySQLDBOperationDao;
import website.dachuan.migration.dao.postgresql.PostgreSQLDBOperationDao;
import website.dachuan.migration.service.*;
import website.dachuan.migration.service.highgo.HighGoDBOperation;
import website.dachuan.migration.service.mysql.MySQLDBOperation;
import website.dachuan.migration.service.postgresql.PostgreSQLDBOperation;
import website.dachuan.migration.spring.props.MigrationAutoProps;
import website.dachuan.migration.utils.DatabaseIdProvider;

import java.util.HashMap;
import java.util.Map;

@Configuration
@EnableConfigurationProperties(MigrationAutoProps.class)
@ConditionalOnProperty(prefix = "migration", name = "enabled", havingValue = "true")
@Slf4j
public class MigrationConfig {
    private final MigrationAutoProps autoProps;
    private final ApplicationContext applicationContext;

    @Autowired
    public MigrationConfig(ApplicationContext applicationContext, MigrationAutoProps props) {
        this.autoProps = props;
        this.applicationContext = applicationContext;
    }

    @Bean
    MigrationRunner createMigrationRunner() {
        return new MigrationRunner(applicationContext, autoProps.getSchema(), jdbcSqlScriptRunner(), migrationRun());
    }

    @Bean
    MigrationRun migrationRun() {
        return new MigrationRun(autoProps.getSchema(), jdbcSchemaHistoryService(), jdbcSqlScriptRunner(), dbOperation());
    }

    Map<String, IDBOperation> dbOperation() {
        Map<String, IDBOperation> idbOperationMap = new HashMap<>(4);
        idbOperationMap.put(DatabaseIdProvider.DatabaseId.PostgreSQL.name(), new PostgreSQLDBOperation(new PostgreSQLDBOperationDao()));
        idbOperationMap.put(DatabaseIdProvider.DatabaseId.MySQL.name(), new MySQLDBOperation(new MySQLDBOperationDao()));
        idbOperationMap.put(DatabaseIdProvider.DatabaseId.HighGo.name(), new HighGoDBOperation(new PostgreSQLDBOperationDao()));
        return idbOperationMap;
    }


    @Bean
    ISqlScriptRunner jdbcSqlScriptRunner() {
        return new SqlScriptRunner();
    }

    @Bean
    ISchemaHistoryService jdbcSchemaHistoryService() {
        return new SchemaHistoryService(new SchemaHistoryDao());
    }

}
