/*
 * Decompiled with CFR 0.152.
 */
package website.dachuan.migration.spring;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.core.annotation.Order;
import website.dachuan.migration.MigrationProcess;
import website.dachuan.migration.props.MigrationProps;
import website.dachuan.migration.service.IDBOperation;
import website.dachuan.migration.service.ISchemaHistoryService;
import website.dachuan.migration.service.ISqlScriptRunner;

@Order(value=1)
public class MigrationRunner
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(MigrationRunner.class);
    private Map<String, DataSource> dataSource;
    private final MigrationProps props;
    private final ISqlScriptRunner scriptRunner;
    private final ISchemaHistoryService schemaHistoryService;
    private final List<String> canDdlAtomicity = new ArrayList<String>(2);
    @Autowired
    private Map<String, IDBOperation> idbOperationMap;

    public MigrationRunner(Map<String, DataSource> dataSource, MigrationProps props, ISqlScriptRunner scriptRunner, ISchemaHistoryService schemaHistoryService) {
        this.dataSource = dataSource;
        this.props = props;
        this.scriptRunner = scriptRunner;
        this.schemaHistoryService = schemaHistoryService;
        this.canDdlAtomicity.add("PostgreSQL");
    }

    public void run(ApplicationArguments args) throws Exception {
        if (this.dataSource == null || this.dataSource.keySet().size() == 0) {
            return;
        }
        for (Map.Entry<String, DataSource> e : this.dataSource.entrySet()) {
            this.runMigration(e.getValue());
        }
        this.dataSource.clear();
        this.dataSource = null;
    }

    private void runMigration(DataSource dataSource) throws Exception {
        Connection conn = null;
        boolean atomicity = false;
        try {
            conn = dataSource.getConnection();
            String databaseProductName = conn.getMetaData().getDatabaseProductName();
            IDBOperation dbOperation = this.idbOperationMap.get(databaseProductName);
            atomicity = this.canDdlAtomicity.stream().allMatch(databaseProductName::equals);
            if (atomicity) {
                conn.setAutoCommit(false);
            }
            MigrationProcess process = new MigrationProcess(this.props, dbOperation, this.scriptRunner, this.schemaHistoryService);
            process.exec(conn);
            if (atomicity) {
                conn.commit();
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            try {
                assert (conn != null);
                if (atomicity) {
                    conn.rollback();
                }
                conn.close();
            }
            catch (SQLException sqlException) {
                log.error("", (Throwable)sqlException);
            }
            throw e;
        }
    }
}

