package website.dachuan.migration.spring;

import com.baomidou.dynamic.datasource.DynamicRoutingDataSource;
import website.dachuan.migration.dao.SchemaHistoryDao;
import website.dachuan.migration.dao.mysql.MySQLDBOperationDao;
import website.dachuan.migration.dao.postgresql.PostgreSQLDBOperationDao;
import website.dachuan.migration.service.*;
import website.dachuan.migration.service.mysql.MySQLDBOperation;
import website.dachuan.migration.service.postgresql.PostgreSQLDBOperation;
import website.dachuan.migration.spring.props.MigrationAutoProps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import javax.sql.DataSource;
import java.util.HashMap;
import java.util.Map;

@Configuration
@EnableConfigurationProperties(MigrationAutoProps.class)
@ConditionalOnProperty(prefix = "migration", name = "enabled", havingValue = "true")
public class MigrationConfig {
    private final MigrationAutoProps autoProps;
    private final Map<String, DataSource> dataSourceMap = new HashMap<>();

    @Autowired
    public MigrationConfig(ApplicationContext applicationContext, MigrationAutoProps props) {
        this.autoProps = props;
        try {
            Class.forName("com.baomidou.dynamic.datasource.DynamicRoutingDataSource", false, getClass().getClassLoader());
            DynamicRoutingDataSource dynamicRoutingDataSource = applicationContext.getBean(DynamicRoutingDataSource.class);
            this.dataSourceMap.putAll(dynamicRoutingDataSource.getDataSources());
        } catch (ClassNotFoundException e) {
            dataSourceMap.putAll(applicationContext.getBeansOfType(DataSource.class));
        }
    }

    @Bean
    MigrationRunner createMigrationRunner() {
        return new MigrationRunner(this.dataSourceMap, autoProps.getSchema(), jdbcSqlScriptRunner(), jdbcSchemaHistoryService());
    }

    @Bean(name = "PostgreSQL")
    IDBOperation postgreSQLDBOperation() {
        return new PostgreSQLDBOperation(new PostgreSQLDBOperationDao());
    }


    @Bean(name = "MySQL")
    IDBOperation mySQLDBOperation() {
        return new MySQLDBOperation(new MySQLDBOperationDao());
    }


    @Bean
    ISqlScriptRunner jdbcSqlScriptRunner() {
        return new SqlScriptRunner();
    }

    @Bean
    ISchemaHistoryService jdbcSchemaHistoryService() {
        return new SchemaHistoryService(new SchemaHistoryDao());
    }

}
