package website.dachuan.migration.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;

public class Files {
    public static String getFileChecksum(MessageDigest digest, File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        byte[] byteArray = new byte[1024];
        int bytesCount;
        while ((bytesCount = fis.read(byteArray)) != -1) {
            digest.update(byteArray, 0, bytesCount);
        }
        fis.close();
        byte[] bytes = digest.digest();
        StringBuilder sb = new StringBuilder();
        for (byte aByte : bytes) {
            sb.append(Integer.toString((aByte & 0xff) + 0x100, 16).substring(1));
        }
        return sb.toString();
    }

    /**
     * 递归获取文件夹下所有文件，包括子文件下
     *
     * @param root 需要遍历的根路径
     * @return 所有文件
     */
    public static List<File> getAllFiles(File root) {
        List<File> files = new ArrayList<>();
        Files.getAllFile(root, files);
        return files;
    }

    private static void getAllFile(File root, List<File> files) {
        if (root != null && root.exists() && root.isDirectory()) {
            File[] fs = root.listFiles();
            if (files != null) {
                for (File f : fs) {
                    if (f.isFile()) {
                        files.add(f);
                    }
                    if (f.isDirectory()) {
                        getAllFile(f, files);
                    }
                }
            }
        }
    }
}
