package website.dachuan.migration.service;

import lombok.extern.slf4j.Slf4j;
import net.sf.jsqlparser.JSQLParserException;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.MapListHandler;
import website.dachuan.migration.bo.SuccessNum;
import website.dachuan.migration.utils.SqlParseUtil;
import website.dachuan.migration.utils.SqlScriptReader;

import java.io.Reader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

@Slf4j
public class SqlScriptRunner implements ISqlScriptRunner {
    private final QueryRunner runner;

    public SqlScriptRunner() {
        this.runner = new QueryRunner();

    }

    @Override
    public List<Map<String, Object>> runScript(Connection conn, String sql, Object... param) throws SQLException {
        ResultSetHandler<List<Map<String, Object>>> rsh = new MapListHandler();
        return this.runner.query(conn, sql, rsh);
    }

    @Override
    public void runScript(Connection conn, Reader reader, SuccessNum successNum) throws SQLException {
        this.runScript(conn, reader, successNum, 1);
    }

    @Override
    public void runScript(Connection conn, Reader reader, SuccessNum successNum, int startNum) throws SQLException {
        if (startNum < 1) {
            startNum = 1;
        }
        List<String> sqlList = SqlScriptReader.readSqlScript(reader);
        for (int i = (startNum - 1); i < sqlList.size(); i++) {
            runner.update(conn, sqlList.get(i));
            successNum.setNum(i + 1);
        }
    }

    @Override
    public void runScript(Connection conn, Reader reader, SuccessNum successNum, int startNum, String tenantCol, String tenantVal) throws SQLException, JSQLParserException {
        if ((tenantCol == null || tenantCol.length() == 0) || (tenantVal == null || tenantVal.length() == 0)) {
            this.runScript(conn, reader, successNum, startNum);
        } else {
            if (startNum < 1) {
                startNum = 1;
            }
            List<String> sqlList = SqlScriptReader.readSqlScript(reader);
            for (int i = (startNum - 1); i < sqlList.size(); i++) {
                // 为sql 添加 租户信息
                String sql = SqlParseUtil.addTenant(sqlList.get(i), tenantCol, tenantVal);
                runner.update(conn, sql);
                successNum.setNum(i + 1);
            }
        }
    }
}
