package website.dachuan.migration.service;

import website.dachuan.migration.dao.SchemaHistoryDao;
import website.dachuan.migration.entity.SchemaHistoryEntity;
import website.dachuan.migration.props.MigrationProps;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class SchemaHistoryService implements ISchemaHistoryService {
    private final SchemaHistoryDao schemaHistoryDao;

    public SchemaHistoryService(SchemaHistoryDao schemaHistoryDao) {
        this.schemaHistoryDao = schemaHistoryDao;
    }

    @Override
    public List<SchemaHistoryEntity> queryLastVersion(Connection conn, MigrationProps props) throws SQLException {
        return schemaHistoryDao.queryLastVersion(conn, props.getSchemaHistoryTableName());
    }

    @Override
    public SchemaHistoryEntity queryLastVersion(Connection conn, MigrationProps props, String model) throws SQLException {
        return schemaHistoryDao.queryLastVersion(conn, props.getSchemaHistoryTableName(), model);
    }

    @Override
    public SchemaHistoryEntity queryByVersion(Connection conn, MigrationProps props, String model, String version) throws SQLException {
        return schemaHistoryDao.queryByVersion(conn, props.getSchemaHistoryTableName(), model, version);
    }

    @Override
    public SchemaHistoryEntity queryBaseLine(Connection conn, MigrationProps props) throws SQLException {
        return schemaHistoryDao.queryBaseLine(conn, props.getSchemaHistoryTableName());
    }

    @Override
    public SchemaHistoryEntity insertOne(Connection conn, MigrationProps props, SchemaHistoryEntity entity) throws SQLException {
        return schemaHistoryDao.insertOne(conn, props.getSchemaHistoryTableName(), entity);
    }

    @Override
    public int updateOne(Connection conn, MigrationProps props, SchemaHistoryEntity entity) throws SQLException {
        return schemaHistoryDao.updateOne(conn, props.getSchemaHistoryTableName(), entity);
    }
}
