package website.dachuan.migration.service.task;

import lombok.extern.slf4j.Slf4j;
import website.dachuan.migration.bo.SQLScriptBo;
import website.dachuan.migration.dao.sql.SqlProviderStrategy;
import website.dachuan.migration.props.MigrationProps;
import website.dachuan.migration.service.MigrationTask;
import website.dachuan.migration.service.task.handles.TaskHandle;
import website.dachuan.migration.utils.Files;

import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import static website.dachuan.migration.commons.Constants.DEPLOY_INIT;
import static website.dachuan.migration.commons.Constants.UNDER_LINE;

/**
 * @author yqb22
 */
@Slf4j
public class DeployInitTableTask implements MigrationTask {
    private final MigrationProps props;
    private final TaskHandle taskHandle;

    public DeployInitTableTask(MigrationProps props, TaskHandle taskHandle) {
        this.props = props;
        this.taskHandle = taskHandle;
    }

    @Override
    public Boolean doTask(Connection conn) throws SQLException, IOException, NoSuchAlgorithmException {
        log.debug("数据库[{}] DeployInitTableTask doTask begin...", conn.getMetaData().getURL());
        // 获取文件路径下的所有要执行的文件
        List<SQLScriptBo> scripts = this.createSqlScriptBo(conn);
        // 分步执行文件
        taskHandle.increaseDbVersion(conn, scripts, null, null);
        log.debug("数据库[{}] DeployInitTableTask doTask end...", conn.getMetaData().getURL());
        return true;
    }

    private List<SQLScriptBo> createSqlScriptBo(Connection conn) throws IOException, SQLException {
        List<SQLScriptBo> sqlScripts = new ArrayList<>();
        File tempDir = Files.getTemp();
        if (tempDir == null) {
            return sqlScripts;
        }
        File folder = new File(tempDir.getAbsolutePath() + File.separator + Files.getDirName(this.props.getScriptDirPath()) + File.separator + SqlProviderStrategy.getSqlProvider(conn).sqlDirName() + File.separator + DEPLOY_INIT);
        if (folder.exists()) {
            // 遍历初始化文件夹下各个模块下文件
            File[] lModel = folder.listFiles(File::isDirectory);
            if (lModel != null) {
                for (File dir : lModel) {
                    List<SQLScriptBo> temp = taskHandle.listDeployInitSqlScriptBo(conn, props, DEPLOY_INIT + UNDER_LINE + dir.getName(), dir, true);
                    if (temp != null && temp.size() > 0) {
                        sqlScripts.addAll(temp);
                    }
                }
            }
            // 遍历deploy_init文件夹下的文件
            sqlScripts.addAll(taskHandle.listDeployInitSqlScriptBo(conn, props, DEPLOY_INIT, folder, false));
        }
        return sqlScripts;
    }
}
