package website.dachuan.migration.service.impl;

import website.dachuan.migration.dao.SchemaHistoryDao;
import website.dachuan.migration.entity.SchemaHistoryEntity;
import website.dachuan.migration.props.MigrationProps;
import website.dachuan.migration.service.ISchemaHistoryService;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

/**
 * @author yqb22
 */
public class SchemaHistoryService implements ISchemaHistoryService {
    private final SchemaHistoryDao schemaHistoryDao;

    public SchemaHistoryService(SchemaHistoryDao schemaHistoryDao) {
        this.schemaHistoryDao = schemaHistoryDao;
    }

    @Override
    public List<SchemaHistoryEntity> queryLastVersion(Connection conn, MigrationProps props) throws SQLException {
        return schemaHistoryDao.queryLastVersion(conn, props.getSchemaHistoryTableName());
    }

    @Override
    public SchemaHistoryEntity queryLastVersion(Connection conn, MigrationProps props, String model) throws SQLException {
        return schemaHistoryDao.queryLastVersion(conn, props.getSchemaHistoryTableName(), model);
    }

    @Override
    public SchemaHistoryEntity queryByVersion(Connection conn, MigrationProps props, String model, String version) throws SQLException {
        return schemaHistoryDao.queryByVersion(conn, props.getSchemaHistoryTableName(), model, version);
    }

    @Override
    public SchemaHistoryEntity queryBaseLine(Connection conn, MigrationProps props) throws SQLException {
        return schemaHistoryDao.queryBaseLine(conn, props.getSchemaHistoryTableName());
    }

    @Override
    public List<SchemaHistoryEntity> queryDeployInit(Connection conn, String model, MigrationProps props) throws SQLException {
        return schemaHistoryDao.queryDeployInit(conn, model, props.getSchemaHistoryTableName());
    }

    @Override
    public void insertOne(Connection conn, MigrationProps props, SchemaHistoryEntity entity) throws SQLException {
        schemaHistoryDao.insertOne(conn, props.getSchemaHistoryTableName(), entity);
    }

    @Override
    public int updateOne(Connection conn, MigrationProps props, SchemaHistoryEntity entity) throws SQLException {
        return schemaHistoryDao.updateOne(conn, props.getSchemaHistoryTableName(), entity);
    }
}
