package website.dachuan.migration.service;

import website.dachuan.migration.bo.SuccessNum;

import java.io.Reader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

/**
 * @author yqb22
 */
public interface ISqlScriptRunner {
    List<Map<String, Object>> runScript(Connection conn, String sql, Object... param) throws SQLException;

    /**
     * 执行数据变更脚本文件
     * <br>脚本执行异常后，修改脚本文件时务必不要修改已经执行成功的代码
     *
     * @param conn       数据库连接
     * @param reader     reading character streams
     * @param successNum sql script 中执行成功的代码块个数
     *                   <br> 代码块为sql执行单元，默认使用 ; 分割
     * @throws SQLException 脚本执行失败
     */
    void runScript(Connection conn, Reader reader, SuccessNum successNum) throws SQLException;

    /**
     * 执行数据变更脚本文件
     * <br>脚本执行异常后，修改脚本文件时务必不要修改已经执行成功的代码
     *
     * @param conn       数据库连接
     * @param reader     reading character streams
     * @param successNum sql script 中执行成功的代码块个数
     *                   <br> 代码块为sql执行单元，默认使用 ; 分割
     * @param startNum   程序开始执行的代码块
     * @throws SQLException 脚本执行失败
     */
    void runScript(Connection conn, Reader reader, SuccessNum successNum, int startNum) throws SQLException;

    /**
     * 执行数据变更脚本文件
     * <br>脚本执行异常后，修改脚本文件时务必不要修改已经执行成功的代码
     * <br>为脚本自动添加租户号
     *
     * @param conn       数据库连接
     * @param reader     reading character streams
     * @param successNum sql script 中执行成功的代码块个数
     *                   <br> 代码块为sql执行单元，默认使用 ; 分割
     * @param startNum   程序开始执行的代码块
     * @param tenantCol  租户列
     * @param tenantVal  租户值
     * @throws SQLException 脚本执行失败
     */
    void runScript(Connection conn, Reader reader, SuccessNum successNum, int startNum, String tenantCol, String tenantVal) throws SQLException;
}
