package website.dachuan.migration.parsesql.util;


import lombok.extern.slf4j.Slf4j;
import website.dachuan.migration.mapping.DatabaseIdProvider;
import website.dachuan.migration.parsesql.Parser;
import website.dachuan.migration.parsesql.SqlStatement;
import website.dachuan.migration.parsesql.SqlStatementIterator;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

/**
 * @author haibo
 */
@Slf4j
public class ParserUtil {
    /**
     * 解析sql文件的內容
     *
     * @param reader              sql文件输入流
     * @param databaseProductName 数据库名称
     * @return SQL语句集合
     */
    public static List<String> parse(Reader reader, String databaseProductName) {
        if (StringUtils.isEmpty(databaseProductName)) {
            throw new RuntimeException("未查询到数据库版本!");
        }
        Parser parser = DatabaseIdProvider.valueOf(databaseProductName).getSqlParser();
        if (parser == null) {
            throw new RuntimeException("此数据库版本暂不支持!");
        }
        List<String> list = new ArrayList<>();
        try (SqlStatementIterator sqlStatementIterator = parser.parse(reader)) {
            while (sqlStatementIterator.hasNext()) {
                SqlStatement next = sqlStatementIterator.next();
                list.add(next.getSql());
            }
        } catch (IOException e) {
            log.error("sql file to str ParserUtil", e);
        }
        return list;
    }
}
