package website.dachuan.migration;

import lombok.extern.slf4j.Slf4j;
import website.dachuan.migration.mapping.DatabaseId;
import website.dachuan.migration.mapping.DatabaseIdProvider;
import website.dachuan.migration.props.MigrationProps;
import website.dachuan.migration.service.task.handles.TaskHandle;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

/**
 * @author yqb22
 */
@Slf4j
public class MigrationTenantDataRun {
    private final MigrationTenantDataProcess process;

    public MigrationTenantDataRun(MigrationProps props, TaskHandle taskHandle) {
        process = new MigrationTenantDataProcess(props, taskHandle);
    }

    public void run(Connection conn, List<String> tenantIds, boolean isPrimary) throws Exception {
        DatabaseId databaseId = DatabaseIdProvider.valueOf(conn);
        if (databaseId == null) {
            return;
        }
        try {
            conn.setAutoCommit(false);
            process.exec(conn, tenantIds, isPrimary);
            conn.commit();
        } catch (Exception e) {
            try {
                conn.rollback();
                conn.close();
            } catch (SQLException sqlException) {
                log.error("", sqlException);
            }
            throw new Exception(e);
        }
    }

}
