package website.dachuan.migration;

import lombok.extern.slf4j.Slf4j;
import website.dachuan.migration.props.MigrationProps;
import website.dachuan.migration.service.task.TenantDataScriptTask;
import website.dachuan.migration.service.task.handles.TaskHandle;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

@Slf4j
class MigrationTenantDataProcess {
    private final MigrationProps props;
    private final TaskHandle taskHandle;

    public MigrationTenantDataProcess(MigrationProps props, TaskHandle taskHandle) {
        this.props = props;
        this.taskHandle = taskHandle;
    }

    public void exec(Connection conn, List<String> tenantIds, boolean isPrimary) throws SQLException, IOException, NoSuchAlgorithmException {
        if (tenantIds == null || tenantIds.size() == 0) {
            if (isPrimary) {
                TenantDataScriptTask task = new TenantDataScriptTask(props, taskHandle, null, true);
                task.doTask(conn);
            }
        } else {
            for (String tenantId : tenantIds) {
                TenantDataScriptTask task = new TenantDataScriptTask(props, taskHandle, tenantId, false);
                task.doTask(conn);
            }
        }

    }
}
