package website.dachuan.migration.service;

import website.dachuan.migration.entity.TenantEntity;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

/**
 * 多租户数据处理
 *
 * @author yqb22
 */
public interface ITenantService {
    /**
     * 查询租户信息。
     * 该方法通过提供的主数据库连接，从指定的租户表中查询特定租户的信息，并返回租户实体列表。
     *
     * @param primary       主数据库的连接对象。
     * @param tenantTable   租户信息存储的表名。
     * @param tenantTableId 表中用于标识租户的字段名。
     * @param tenantJdbcUrl 租户数据库的JDBC URL。
     * @return 租户实体列表，每个实体代表一个租户的信息。
     * @throws SQLException 如果查询过程中发生数据库操作错误，则抛出SQLException。
     */
    List<TenantEntity> queryTenantInfo(Connection primary, String tenantTable, String tenantTableId, String tenantJdbcUrl) throws SQLException;

}
