package website.dachuan.migration.props;

import lombok.Data;

import java.io.Serializable;

@Data
public class MigrationProps implements Serializable {
    // 设置迁移时的编码，默认UTF-8
    private String encoding = "UTF-8";
    // 迁移脚本的位置，默认 migration
    private String scriptDirPath = "migration";
    // 开始执行基准迁移时对现有的schema的版本打标签，默认值为 1.0.0
    private String baselineVersion = "1.0.0";
    // 数据库版本管理表，默认"schema_history"
    private String schemaHistoryTableName = "schema_history";
    // 文件的前缀，默认为V.
    private String sqlMigrationPrefix = "V";
    // 脚本的文件名分隔符，默认__
    private String sqlMigrationSeparator = "__";
    // 脚本的后缀，默认为.sql
    private String sqlMigrationSuffix = ".sql";
    // 启用多租户数据
    private TenantDataMigrationProps tenantData = new TenantDataMigrationProps();
}
