package website.dachuan.migration.mapping.provider;

import website.dachuan.migration.mapping.DatabaseId;
import website.dachuan.migration.parsesql.Parser;
import website.dachuan.migration.parsesql.database.PostgreSQLParser;

public class PgDatabaseId implements DatabaseId {
    @Override
    public String name() {
        return "PostgreSQL";
    }

    @Override
    public String uk() {
        return "postgresql";
    }

    @Override
    public boolean ddlTransaction() {
        return true;
    }

    @Override
    public boolean autoIncrement() {
        return true;
    }

    @Override
    public Parser getSqlParser() {
        return new PostgreSQLParser();
    }
}
