package website.dachuan.migration.mapping;

import website.dachuan.migration.parsesql.Parser;

/**
 * @author yqb22
 */
public interface DatabaseId {
    /**
     * 获取名称。
     *
     * @return 返回该对象的名称，返回类型为String。
     */
    String name();

    /**
     * 获取UK标识。
     *
     * @return 返回该对象的UK标识，返回类型为String。
     */
    String uk();

    /**
     * 判断是否使用DDL事务。
     *
     * @return 如果使用DDL事务则返回true，否则返回false。
     */
    boolean ddlTransaction();

    /**
     * 判断是否自动递增。
     *
     * @return 如果是自动递增则返回true，否则返回false。
     */
    boolean autoIncrement();

    /**
     * 获取SQL解析器。
     *
     * @return 返回该对象使用的SQL解析器。
     */
    Parser getSqlParser();

}
