package website.dachuan.migration.entity;

import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import static website.dachuan.migration.commons.Constants.DEPLOY_INIT;

/**
 * @author yqb22
 */
@Data
@ToString
public class SchemaHistoryEntity implements Serializable {
    private Pattern ptnVersionPattern = Pattern.compile("^(\\d+)\\.(\\d+)\\.(\\d+)$");

    private Long id;
    /**
     * 约定：当前数据目录(例：MySQL)下只能全部是`文件夹`（模块）[模块下是迭代脚本]或者是`文件`（迭代脚本）[当前场景下model=base]
     */
    private String model;
    /**
     * 主版本号，一个业务空间对应的主版本号，对应"x.y.z"中的x，只支持非负整数
     */
    private Integer majorVersion;
    /**
     * 次版本号，一个业务空间对应的次版本号，对应"x.y.z"中的y，只支持非负整数
     */
    private Integer minorVersion;
    /**
     * 补丁版本号，一个业务空间对应的补丁版本号，对应"x.y.z"中的z，只支持非负整数
     */
    private Integer patchVersion;
    private String version;
    private String description;
    private String type;
    private String scriptPath;
    private String checksum;
    private Integer success;
    private Integer codeBlockNum;
    private Long executionTime;
    private String createdBy;
    private Date createdTime;
    private String updateBy;
    private Date updateTime;

    public void setVersion(String version) {
        Matcher matcher = ptnVersionPattern.matcher(version);
        if (model.startsWith(DEPLOY_INIT)) {
            this.majorVersion = 1;
            this.minorVersion = 0;
            this.patchVersion = 0;
            this.version = version;
        } else if (matcher.matches()) {
            this.majorVersion = Integer.parseInt(matcher.group(1));
            this.minorVersion = Integer.parseInt(matcher.group(2));
            this.patchVersion = Integer.parseInt(matcher.group(3));
            this.version = version;
        } else {
            throw new RuntimeException("版本号异常！");
        }
    }
}
