package website.dachuan.migration.dao.sql.dialect;

import website.dachuan.migration.mapping.DatabaseId;
import website.dachuan.migration.mapping.provider.PgDatabaseId;

public class PostgreSQLSqlProvider extends CommonSqlProvider {
    private final DatabaseId pgDatabaseId = new PgDatabaseId();

    @Override
    public DatabaseId[] key() {
        return new DatabaseId[]{
                pgDatabaseId
        };
    }

    @Override
    public String sqlDirName() {
        return pgDatabaseId.name();
    }

    @Override
    public String getListTablesSql() {
        return "SELECT tablename FROM pg_tables pt where schemaname = (select current_schema());";
    }
}
