package website.dachuan.migration.dao;

import org.apache.commons.dbutils.*;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import website.dachuan.migration.entity.TenantEntity;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

/**
 * @author yqb22
 */
public class TenantDao {
    private final QueryRunner queryRunner;
    private final RowProcessor processor;

    public TenantDao() {
        this.queryRunner = new QueryRunner();
        BeanProcessor bean = new GenerousBeanProcessor();
        this.processor = new BasicRowProcessor(bean);
    }

    public List<TenantEntity> queryAllTenantInfo(Connection conn, String tenantTable, String tenantTableId, String tenantJdbcUrl) throws SQLException {
        StringBuilder sql = new StringBuilder("select ")
                .append(tenantTableId).append(" as tenantId, ")
                .append(tenantJdbcUrl).append(" as url ")
                .append(" from ").append(tenantTable);
        return queryRunner.query(conn, sql.toString(), new BeanListHandler<>(TenantEntity.class, processor));
    }
}
