package website.dachuan.migration;

import lombok.extern.slf4j.Slf4j;
import website.dachuan.migration.mapping.DatabaseId;
import website.dachuan.migration.mapping.DatabaseIdProvider;
import website.dachuan.migration.props.MigrationProps;
import website.dachuan.migration.service.IDBOperation;
import website.dachuan.migration.service.ISchemaHistoryService;
import website.dachuan.migration.service.ISqlScriptRunner;
import website.dachuan.migration.service.task.handles.TaskHandle;

import java.sql.Connection;
import java.sql.SQLException;

/**
 * @author yqb22
 */
@Slf4j
public class MigrationRun {
    private final MigrationProcess process;

    public MigrationRun(MigrationProps props, ISchemaHistoryService schemaHistoryService, ISqlScriptRunner scriptRunner, TaskHandle taskHandle, IDBOperation dbOperation) {
        process = new MigrationProcess(props, dbOperation, scriptRunner, taskHandle, schemaHistoryService);
    }

    /**
     * 当前数据源脚本自动升级
     *
     * @param conn 数据源
     */
    public void run(Connection conn) throws Exception {
        DatabaseId databaseId = DatabaseIdProvider.valueOf(conn);
        if (databaseId == null) {
            return;
        }
        try {
            if (databaseId.ddlTransaction()) {
                conn.setAutoCommit(false);
            }
            process.exec(conn);
            if (databaseId.ddlTransaction()) {
                conn.commit();
            }
        } catch (Exception e) {
            try {
                if (databaseId.ddlTransaction()) {
                    conn.rollback();
                }
                conn.close();
            } catch (SQLException sqlException) {
                log.error("", sqlException);
            }
            throw new Exception(e);
        }
    }
}
