package website.dachuan.migration.parsesql;

/**
 * A sql statement from a script that can be executed at once against a database.
 *
 * @author haibo
 */
public class ParsedSqlStatement implements SqlStatement {
    private final int pos;
    private final int line;
    private final int col;
    private final String sql;

    public int getPos() {
        return pos;
    }

    public int getLine() {
        return line;
    }

    public int getCol() {
        return col;
    }

    /**
     * The delimiter of the statement.
     */
    private final Delimiter delimiter;

    private final boolean canExecuteInTransaction;


    public ParsedSqlStatement(int pos, int line, int col, String sql, Delimiter delimiter, boolean canExecuteInTransaction) {
        this.pos = pos;
        this.line = line;
        this.col = col;
        this.sql = sql;
        this.delimiter = delimiter;
        this.canExecuteInTransaction = canExecuteInTransaction;
    }

    @Override
    public final String getSql() {
        return sql;
    }

    @Override
    public String getDelimiter() {
        return delimiter.toString();
    }
}
