package website.dachuan.migration.mapping.provider;

import website.dachuan.migration.mapping.DatabaseId;
import website.dachuan.migration.parsesql.Parser;
import website.dachuan.migration.parsesql.database.MySQLParser;

public class MysqlDatabaseId implements DatabaseId {
    @Override
    public String name() {
        return "MySQL";
    }

    @Override
    public String uk() {
        return "mysql";
    }

    @Override
    public boolean ddlTransaction() {
        return false;
    }

    @Override
    public boolean autoIncrement() {
        return true;
    }

    @Override
    public Parser getSqlParser() {
        return new MySQLParser();
    }
}
