package website.dachuan.migration.dao.handler;

import org.apache.commons.dbutils.ColumnHandler;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;

/**
 * @author yqb22
 */
public class DateColumnHandler implements ColumnHandler {
    @Override
    public boolean match(Class<?> propType) {
        try {
            return propType.equals(Date.class);
        } catch (Exception e) {
            return false;
        }
    }

    @Override
    public Object apply(ResultSet rs, int columnIndex) throws SQLException {
        if (rs.getTimestamp(columnIndex) != null) {
            return new Date(rs.getTimestamp(columnIndex).getTime());
        }
        return null;
    }
}
