package website.dachuan.migration.service.task;

import lombok.extern.slf4j.Slf4j;
import net.sf.jsqlparser.JSQLParserException;
import website.dachuan.migration.bo.SQLScriptBo;
import website.dachuan.migration.dao.sql.SqlProviderStrategy;
import website.dachuan.migration.props.MigrationProps;
import website.dachuan.migration.service.MigrationTask;
import website.dachuan.migration.utils.Files;
import website.dachuan.migration.utils.SqlScriptCommon;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import static website.dachuan.migration.commons.Constants.DEPLOY_INIT;

@Slf4j
public class TenantDataInitScriptTask implements MigrationTask {
    private final MigrationProps props;
    private final SqlScriptCommon sqlScriptCommon;
    private final String tenantId;

    public TenantDataInitScriptTask(MigrationProps props, SqlScriptCommon sqlScriptCommon, String tenantId) {
        this.props = props;
        this.sqlScriptCommon = sqlScriptCommon;
        this.tenantId = tenantId;
    }

    @Override
    public Boolean doTask(Connection conn) throws SQLException, IOException, JSQLParserException, NoSuchAlgorithmException {
        log.debug("数据库[{}] TenantDataInitScriptTask doTask begin ...", conn.getMetaData().getURL());
        // 获取文件路径下的所有要执行的文件
        List<SQLScriptBo> scripts = this.createSqlScriptBo(conn);
        // 分步执行文件
        sqlScriptCommon.increaseDbVersion(conn, scripts, props.getTenantData().getTenantIdColumn(), tenantId);
        log.debug("数据库[{}] TenantDataInitScriptTask doTask end ...", conn.getMetaData().getURL());
        return true;
    }

    private List<SQLScriptBo> createSqlScriptBo(Connection conn) throws IOException, SQLException {
        File folder = new File(Files.getTemp().getAbsolutePath() + File.separator + Files.getDirName(this.props.getTenantData().getScriptDirPath()) + File.separator + SqlProviderStrategy.getSqlProvider(conn).sqlDirName() + File.separator + DEPLOY_INIT);
        if (folder.exists()) {
            return new ArrayList<>();
        }
        return sqlScriptCommon.listTenantDir(conn, folder, false, tenantId);
    }
}
