package website.dachuan.migration.parsesql;

/**
 * SqlStatementIterator 接口定义了一个能够迭代处理 SqlStatement 对象的集合，同时继承了 CloseableIterator 接口，
 * 以支持在迭代完成后对资源进行清理。
 *
 * @author haibo
 */
public interface SqlStatementIterator extends CloseableIterator<SqlStatement> {

    /**
     * 关闭迭代器，释放相关资源。
     * 此方法在迭代完成后调用，用于释放迭代过程中可能占用的系统资源。
     */
    @Override
    void close();
}

