package website.dachuan.migration.mapping.provider;

import website.dachuan.migration.mapping.DatabaseId;
import website.dachuan.migration.parsesql.Parser;
import website.dachuan.migration.parsesql.database.OracleParser;

public class OracleDatabaseId implements DatabaseId {
    @Override
    public String name() {
        return "Oracle";
    }

    @Override
    public String uk() {
        return "oracle";
    }

    @Override
    public boolean ddlTransaction() {
        return false;
    }

    @Override
    public boolean autoIncrement() {
        return false;
    }

    @Override
    public Parser getSqlParser() {
        return new OracleParser();
    }
}
