package website.dachuan.migration.service.task;

import lombok.extern.slf4j.Slf4j;
import net.sf.jsqlparser.JSQLParserException;
import website.dachuan.migration.bo.SQLScriptBo;
import website.dachuan.migration.dao.sql.SqlProviderStrategy;
import website.dachuan.migration.props.MigrationProps;
import website.dachuan.migration.service.MigrationTask;
import website.dachuan.migration.utils.Files;
import website.dachuan.migration.utils.SqlScriptCommon;

import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

@Slf4j
public class IncreaseVersionTask implements MigrationTask {
    private final MigrationProps props;
    private final SqlScriptCommon sqlScriptCommon;

    public IncreaseVersionTask(MigrationProps props, SqlScriptCommon sqlScriptCommon) {
        this.props = props;
        this.sqlScriptCommon = sqlScriptCommon;
    }

    @Override
    public Boolean doTask(Connection conn) throws IOException, SQLException, NoSuchAlgorithmException, JSQLParserException {
        log.debug("数据库[{}] IncreaseVersionTask doTask begin ...", conn.getMetaData().getURL());
        // 获取文件路径下的所有要执行的文件
        List<SQLScriptBo> scripts = this.createSqlScriptBo(conn);
        // 校验需要执行的数据脚本其存放路径是否符合规范
        sqlScriptCommon.listSqlScriptBoCheck(scripts);
        // 分步执行文件
        sqlScriptCommon.increaseDbVersion(conn, scripts, null, null);
        log.debug("数据库[{}] IncreaseVersionTask doTask end ...", conn.getMetaData().getURL());
        return true;
    }

    private List<SQLScriptBo> createSqlScriptBo(Connection conn) throws IOException, SQLException {
        List<SQLScriptBo> sqlScripts = new ArrayList<>();
        File folder = new File(Files.getTemp().getAbsolutePath() + File.separator + Files.getDirName(this.props.getScriptDirPath()) + File.separator + SqlProviderStrategy.getSqlProvider(conn).sqlDirName());
        if (folder.exists()) {
            // 遍历主文件夹下各个模块下文件
            File[] l_model = folder.listFiles(File::isDirectory);
            if (l_model != null) {
                for (File dir : l_model) {
                    if ("deploy_init".equals(dir.getName())) {
                        continue;
                    }
                    List<SQLScriptBo> temp = sqlScriptCommon.listSqlScriptBo(conn, dir.getName(), dir, null, true);
                    if (temp != null && temp.size() > 0) {
                        sqlScripts.addAll(temp);
                    }
                }
            }
            // 遍历主文件夹下的文件
            sqlScripts.addAll(sqlScriptCommon.listSqlScriptBo(conn, "base", folder, null, false));
        }
        return sqlScripts;
    }
}
